from django.shortcuts import render, redirect, get_object_or_404
from django.urls import reverse
from django.views import View
from web.forms import ArticleForm
from web.models import Article, StatusChoices


def index_view(request):
    return render(
        request, 'index.html', context={
            'articles': Article.objects.order_by('title'),
            'reverse': reverse('articles-detail', kwargs={'id': 1})
        }
    )


# Class-based views
class ArticleCreateView(View):
    def get(self, request, *args, **kwargs):
        form = ArticleForm()
        
        return render(
            self.request,
            'article_create.html',
            context={
                'status_choices': StatusChoices.choices,
                'form': form
            }
        )

    def post(self, request, *args, **kwargs):
        errors = {}
        data = request.POST
        form = ArticleForm(data=data)
        if form.is_valid():
            article = Article.objects.create(
                title=form.cleaned_data['title'],
                status=form.cleaned_data['status'],
                text=form.cleaned_data['text'],
                author=form.cleaned_data['author'],
            )
            return redirect(redirect('articles-detail', id=article.id))
        else:
            return render(self.request, 'article_create.html', context={'form': form, 'status_choices': StatusChoices.choices})



        # title = request.POST.get('title')
        # if not title:
        #     errors['title'] = 'Title should not be empty!'
        # elif len(title) > 200:
        #     errors['title'] = 'Title should be 200 symbols or less'

        # author = request.POST.get('author')
        # if not author:
        #     errors['author'] = 'Author should not be empty!'
        # elif len(author) > 40:
        #     errors['author'] = 'Author should be 40 symbols or less'

        # text = request.POST.get('text')
        # if not text:
        #     errors['text'] = 'Text should not be empty!'
        # elif len(text) > 3000:
        #     errors['text'] = 'Text should be 3000 symbols or less'
        # status = request.POST.get('status')
        # if not status:
        #     errors['status'] = 'Status should not be empty!'

        # if len(errors) > 0:
        #     article_not_saved = Article(title=title, status=status, text=text, author=author)
        #     return render(self.request,
        #         'article_create.html',
        #         context={
        #             'status_choices': StatusChoices.choices,
        #             'errors': errors,
        #             'article': article_not_saved
        #     })

        article = Article.objects.create(title=title, author=author, status=status, text=text)

        return redirect('articles-detail', id=article.id)


# def article_create_view(request):
#     if request.method == 'GET':
#         return render(
#             request,
#             'article_create.html',
#             context={
#                 'status_choices': StatusChoices.choices
#             }
#         )
#
#     elif request.method == 'POST':
#         data = request.POST
#         article_data = {
#             'title': data.get('title'),
#             'text': data.get('text'),
#             'author': data.get('author'),
#             'status': data.get('status')
#         }
#
#         article = Article.objects.create(**article_data)
#
#         return redirect('articles-detail', id=article.id)


# /articles/{id}
def article_detail_view(request, id: int):
    article = get_object_or_404(Article, id=id)
    return render(request, 'article.html', context={'article': article})


def article_update_view(request, id):
    article = get_object_or_404(Article, pk=id)
    if request.method == 'GET':
        form = ArticleForm(initial={
            'title': article.title,
            'status': article.status,
            'author': article.author,
            'text': article.text
        })
        return render(request, 'update.html', context={'article': article, 'form': form, 'status_choices': StatusChoices.choices})
    elif request.method == 'POST':
        form = ArticleForm(data=request.POST)
        if form.is_valid():

            article.title = request.POST.get('title')
            article.author = request.POST.get('author')
            article.text = request.POST.get('text')
            article.status = request.POST.get('status')
            article.save()
            return redirect('articles-detail', id=article.pk)
        else:
            return render(request, 'update.html', context={'article': article, 'form': form, 'status_choices': StatusChoices.choices}))
    

def delete_article(request, id):
    article = get_object_or_404(Article, pk=id)
    if request.method == 'GET':
        return render(request, 'delete.html', context={'article': article})

    elif request.method == 'POST':
        article.delete()
        return redirect('main-page')
