from django.db import models
from django.db.models import TextChoices


class StatusChoices(TextChoices):
    ACCEPTED = 'accepted', 'Разрешено'
    UNACCEPTED = 'unaccepted', 'Не разрешено'
    CHECK = 'check', 'На проверке'


class Article(models.Model):
    # CharField = varchar
    # title varchar(200) not null
    title = models.CharField(
        max_length=200,
        null=False,  # <null>
        blank=False,  # ''
        verbose_name='Заголовок'
    )

    # accepted, check, unaccepted
    status = models.CharField(
        max_length=100,
        choices=StatusChoices.choices,
        default='check'
    )

    text = models.TextField(
        max_length=3000,
        null=False,
        blank=False,
        verbose_name='Текст'
    )

    author = models.CharField(
        max_length=100,
        null=False,
        blank=False,
        default='Unknown',
        verbose_name='Автор'
    )

    created_at = models.DateTimeField(
        auto_now_add=True,
        verbose_name='Дата создания'
    )

    updated_at = models.DateTimeField(
        auto_now=True,
        verbose_name='Дата обновления'
    )

    class Meta:
        verbose_name = 'статью'
        verbose_name_plural = 'статьи'

    def __str__(self):
        return f'{self.author}: {self.title}'
