"""core URL Configuration

The `urlpatterns` list routes URLs to views. For more information please see:
    https://docs.djangoproject.com/en/3.2/topics/http/urls/
Examples:
Function views
    1. Add an import:  from my_app import views
    2. Add a URL to urlpatterns:  path('', views.home, name='home')
Class-based views
    1. Add an import:  from other_app.views import Home
    2. Add a URL to urlpatterns:  path('', Home.as_view(), name='home')
Including another URLconf
    1. Import the include() function: from django.urls import include, path
    2. Add a URL to urlpatterns:  path('blog/', include('blog.urls'))
"""
from django.conf import settings
from django.conf.urls.static import static
from django.contrib import admin
from django.urls import path
from web import views

urlpatterns = [
    path('admin/', admin.site.urls),
    path('', views.index_view, name='main-page'),
    path('articles/add/', views.ArticleCreateView.as_view(), name='articles-add'),
    # /articles/1/ OR /articles/?id=1
    # article_details_view(request, id)
    path('articles/<int:id>/', views.article_detail_view, name='articles-detail'),
    path('articles/<int:id>/edit', views.article_update_view, name='article_update'),
    path('articles/<int:id>/delete', views.delete_article, name='delete_article')
] + static(settings.MEDIA_URL, document_root=settings.MEDIA_ROOT)
