import { Box, Divider, Grid, IconButton, TextField, Tooltip, Typography, } from "@mui/material";
import { styled } from '@mui/material/styles';
import { memo } from "react";
import { priorities } from "../../../../constants";
import CustomSelect from "../../../UI/СustomSelect/СustomSelect"
import MaterialUIPickers from "../DateTimePicker/DateTimePicker";
import { Save } from "@mui/icons-material";
import { isValidate } from "./helpers";

const StyledTooltip = styled(({ className, ...props }) => (
  <Tooltip {...props} classes={{ popper: className }} />
))`
  & .MuiTooltip-tooltip {
    background: white;
  }
`;



function MyTaskNewTaskForm({ addFormStatus, onChangeNewTaskHandler, newTask, allUserProjectsForModalTask, onDateChangeHandler, createNewTaskHandler }) {

  return (
    <Box sx={{
      height: addFormStatus ? '200px' : '0px',
      transition: 'all 0.3s linear',
      visibility: addFormStatus ? 'visible' : 'hidden',
      transform: addFormStatus ? 'translateY(0)' : 'translateY(-20vh)'
    }}>
      <Box>
        <Divider>
          <Typography variant="overline">Добавить новую задачу</Typography>
        </Divider>
        <Box sx={{
          backgroundColor: "#E8E8E8",
          marginBottom: "2em",
        }}>
          <Grid container padding={2}>
            <Grid item xs={1}>Приоритеты</Grid>
            <Grid item xs={5}>Заголовок</Grid>
            <Grid item xs={2}>Проект</Grid>
            <Grid item xs={3}>Дедлайн</Grid>
            <Grid item xs={1}></Grid>
          </Grid>
          <Grid container padding={2} alignItems='center'>
            <Grid item xs={1}>
              <CustomSelect
                defaultValue={priorities[0]?.value}
                value={newTask.priority}
                name={'priority'}
                variant={'outlined'}
                onChange={onChangeNewTaskHandler}
                id={'priority-type'}
                items={priorities}
                sx={{ width: '90%' }}
              />
            </Grid>
            <Grid item xs={5}>
              <StyledTooltip
                title={<TextField
                  id="task-description"
                  value={newTask.description}
                  variant="outlined"
                  name='description'
                  placeholder='Описание'
                  sx={{ width: '300px' }}
                  onChange={onChangeNewTaskHandler}
                  multiline
                  rows={5}

                />}>
                <TextField
                  id="task-title"
                  value={newTask.title}
                  variant="outlined"
                  name='title'
                  sx={{ width: '90%' }}
                  onChange={onChangeNewTaskHandler}
                />
              </StyledTooltip>
            </Grid>
            <Grid item xs={2}>
              <CustomSelect
                value={newTask.project}
                name={'project'}
                variant={'outlined'}
                onChange={onChangeNewTaskHandler}
                id={'project'}
                items={allUserProjectsForModalTask}
                sx={{ width: '90%' }}
              />
            </Grid>
            <Grid item xs={3}>
              <MaterialUIPickers
                task={newTask}
                name="dateTimeDeadLine"
                onChange={onDateChangeHandler}
              />
            </Grid>
            <Grid item xs={1} >
              <IconButton disabled={!isValidate(newTask.title, newTask.description)} onClick={createNewTaskHandler}>
                <Save />
              </IconButton>
            </Grid>
          </Grid>
          <Grid container></Grid>
        </Box >
        <Divider />
      </Box>
    </Box>);
}

export default memo(MyTaskNewTaskForm)