import { AppBar, Toolbar, } from '@mui/material';
import { Box } from '@mui/system';
import ButtonSwapCalendar from '../../UI/ButtonSwapCalendar/ButtonSwapCalendar';
import CalendarUserDisplayName from '../../UI/CalendarUserDisplayName/CalendarUserDisplayName';
import MonthAndYearInfo from './MonthAndYearInfo/MonthAndYearInfo';

function MonthCalendarHeader({ currentMonthString, decrementMonth, incrementMonth, year, handleOpen, currentCalendarDisplayName, user, userId}) {

  return (
    <>
      <Box sx={{ flexGrow: 1 }}>
        <AppBar position="static">
          <Toolbar>

            <Box>
              
              <CalendarUserDisplayName
                currentCalendarDisplayName={currentCalendarDisplayName}
              />

              <MonthAndYearInfo
                currentMonthString={currentMonthString}
                decrementMonth={decrementMonth}
                incrementMonth={incrementMonth}
                year={year}
              />
            </Box>

             <ButtonSwapCalendar
              user={user}
              userId={userId}
              handleOpen={handleOpen}
             />
          </Toolbar>
        </AppBar>
      </Box>
    </>
  );
}

export default MonthCalendarHeader;