import {
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,

  } from 'typeorm';

  import {Task} from './Task';


  interface IDateTimeTask{
    id: string;
    createdAt: Date;
    dateTimeStart: Date;
    dateTimeDue: Date;
    task: Task;
  }



  @Entity({name:"DateTimeTask"})
  export class DateTimeTask extends BaseEntity implements IDateTimeTask{
    @PrimaryGeneratedColumn("uuid")
    id!: string;
  
    @CreateDateColumn({ name: 'createdAt', type: Date, default: new Date() })
    createdAt!: Date;

    @CreateDateColumn({ name: 'dateTimeStart', type: Date, nullable:false })
    dateTimeStart!: Date;

    @CreateDateColumn({ name: 'dateTimeDue', type: Date, nullable:false })
    dateTimeDue!: Date;


    @ManyToOne(() => Task, (task: { dateTimeTasks: DateTimeTask[]; }) => task.dateTimeTasks,{cascade: true,  onUpdate:'CASCADE',onDelete:'CASCADE',nullable:true})
    task!: Task;
}