import * as React from "react";
import Box from "@mui/material/Box";
import InputLabel from "@mui/material/InputLabel";
import MenuItem from "@mui/material/MenuItem";
import FormControl from "@mui/material/FormControl";
import Select from "@mui/material/Select";

export default function BasicSelect({value,label,name,onChange,task,items}) {
  console.log('select value ', value)
  console.log('select label ', label)
  console.log('select name ', name)
  console.log('select task ', task)
  console.log('select items ', items)
  return (
    <Box sx={{ minWidth: 60, m: 0}}>
      <FormControl fullWidth>
        <InputLabel id="demo-simple-select-label"></InputLabel>
        <Select
          labelId="demo-simple-select-label"
          id="demo-simple-select"
          value={value}
          label={label}
          name={name}
          onChange={(e) => onChange(e, task)}
        >
          {items ?items.map((item,index) => (
            <MenuItem key={index} value={item.value}>
              {item.title}
            </MenuItem>
          )):null}
        </Select>
      </FormControl>
    </Box>
  );
}

