import { Grid } from "@mui/material";
import { Box } from "@mui/system";
import { useCallback, useState } from "react";
import ModalTask from "../../ModalTask/ModalTask";
import MonthCalendarModalContent from "../../CalendarModalTaskContent/CalendarModalTaskContent";
import CalendarRow from "../../CalendarRow/CalendarRow";
import CalendarSmallCell from "../../CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "../../CalendarStandartCell/CalendarStandartCell";
import HourFormatSwitch from "../../HourFormatSwitch/HourFormatSwitch";
import CalendarColumnDayWeek from "./CalendarColumnDayWeek/CalendarColumnDayWeek";
import { getCurrentWeekDayString, getMonthToDayColumn } from "./Helpers";

function WeekCalendarBody({ week, hoursInDay, hourFormat, setHourFormat, date, tasks, currentTask, setCurrentTask, onChangeCurrentTaskHandler, deleteTaskHandler, sendNewTaskHandler, createTaskInCellHandler, copyTask, setCopyTask, createCopyTask, dragTaskHandler }) {
  const [modal, setModal] = useState({ open: false, y: 0, x: 0, });
  const handleOpen = useCallback((e) => {
    setModal({
      open: true,
      yClickСordinates: e.clientY,
      xClickСordinates: e.clientX,
      yDivClick: e.nativeEvent.offsetY,
      xDivClick: e.nativeEvent.offsetX,
      yDiv: e.target.offsetHeight,
      xDiv: e.target.offsetWidth,
    })
  }, []);

  const handleClose = useCallback(() => {
    setModal({ ...modal, open: false })
    setCurrentTask({})
  }, [setCurrentTask, modal]);

  return (
    <>
      <Box style={{ marginBottom: '30px' }}>
        <Box style={{ position: 'sticky', top: '0px', zIndex: '10', backgroundColor: 'lightgrey' }}>
          <CalendarRow
          >
            <CalendarSmallCell xs={1}>
              <HourFormatSwitch
                hourFormat={hourFormat}
                setHourFormat={setHourFormat}
              />
            </CalendarSmallCell>
            {week?.map((weekDay, i) => {
              return (
                <CalendarStandartCell key={i} xs={11 / week.length}>
                  <span style={{ display: 'block', fontWeight: "600" }}>{weekDay}</span>
                  <span style={{ marginBottom: '10px' }}>{getCurrentWeekDayString(i)}</span>
                </CalendarStandartCell>
              )
            })}
          </CalendarRow>
        </Box>

        <Grid container>
          <CalendarRow week={true}>
            <Grid item xs={0.995} flexDirection='column'>
              {hoursInDay?.map((hour, i) => {
                return (
                  <CalendarSmallCell key={i} week={true}>
                    {hour}
                  </CalendarSmallCell>)
              })}
            </Grid>

            <Grid item xs={11.005}>
              <CalendarRow week={true}>
                {week?.map((weekDay, i) => {
                  return (
                    <CalendarColumnDayWeek
                      key={i}
                      hoursInDay={hoursInDay}
                      tasks={tasks}
                      month={getMonthToDayColumn(week, weekDay, date.month)}
                      year={date.year}
                      day={weekDay}
                      hourFormat={hourFormat}
                      setCurrentTask={setCurrentTask}
                      handleOpen={handleOpen}
                      createTaskInCellHandler={createTaskInCellHandler}
                      modal={modal.open}
                      copyTask={copyTask} 
                      setCopyTask={setCopyTask} 
                      createCopyTask={createCopyTask}
                      dragTaskHandler={dragTaskHandler}
                    />
                  )
                })}
              </CalendarRow>
            </Grid>

          </CalendarRow>
        </Grid>
      </Box>

      <ModalTask
        modal={modal}
        handleClose={() => { handleClose() }}
        week={true}
      >
        <MonthCalendarModalContent
          title={currentTask.title}
          description={currentTask.description}
          priority={currentTask.priority}
          id={currentTask.id}
          startHour={currentTask.infoForCell?.startHour}
          endHour={currentTask.infoForCell?.endHour}
          onChangeCurrentTaskHandler={(e) => { onChangeCurrentTaskHandler(e) }}
          sendNewTaskHandler={() => { sendNewTaskHandler(); handleClose() }}
          deleteTaskHandler={() => { deleteTaskHandler(currentTask.id); handleClose() }}
        />
      </ModalTask>
    </>
  );
}

export default WeekCalendarBody;