import { Box } from "@mui/material"
import { useEffect, useState, memo, useCallback, useMemo } from "react"
import { getColorTaskByPriority } from "../../../../../../helpers/CalendarHelpers"
import ContentCopyIcon from '@mui/icons-material/ContentCopy';


function CalendarWeekTask({ height, width, left, top, task, zIndex, handleOpen, setCurrentTask, modal, setCopyTask, month, dragTaskHandler, step, hourFormat}) {
  const [zIndexStyle, setZIndexStyle] = useState(10)
  const color = useMemo(() => {
    return getColorTaskByPriority(task.priority)
  }, [task.priority])

  useEffect(() => {
    if (!modal) {
      setZIndexStyle(zIndex)
    }
  }, [modal, zIndex])

  const onClickTaskHandler = useCallback((e, task) => {
    e.stopPropagation();
    setCurrentTask((prevState) => {
      return {
        ...task,
        infoForCell: {
          ...task.infoForCell,
          endHour: task.infoForCell.endHour + 1,
          month: month
        }
      }
    });
    setZIndexStyle(100)
    handleOpen(e)
  }, [handleOpen, setCurrentTask, month])

  const styles = {
    boxSizing: 'border-box',
    borderRadius: '3px',
    border: '1px solid white',
    backgroundColor: color,
    height: `${height - 1}px`,
    width: `${width - 1}px`,
    position: 'absolute',
    display: 'flex',
    left: left,
    top: top,
    zIndex: zIndexStyle,
    textAlign: 'left',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    '&:hover': {
      cursor: 'pointer',
      boxShadow: 'inset 0 0 100px 100px rgba(255, 255, 255, 0.3)'
    },
  }

  const dragStartHandler = (e, task) => {
    setCurrentTask((prevState) => {
      return {
        ...task,
        infoForCell: {
          ...task?.infoForCell,
          month: month
        }
      }
    });
  }

  const dragEndHandler = (e) => {
    e.target.style.boxShadow = 'none'
  }

  const dragOverHandler = (e) => {
    e.preventDefault();
  }

  const dropHandler = (e, task) => {
    e.preventDefault();
    let hour
    if (hourFormat) {
      hour = task.infoForCell.startHour + (Math.ceil(e.nativeEvent.offsetY/step)-1) 
    } else {
      hour = task.infoForCell.startHour + (Math.ceil(e.nativeEvent.offsetY/step)-1 + Math.ceil(e.nativeEvent.offsetY/step)-1) 
    }
    dragTaskHandler(task.infoForCell.startDay, hour)
  }

  const dragLeaveHandler = (e) => {
    e.preventDefault();

  }
  return (
    <Box
      draggable={true}
      onDragStart={(e) => { dragStartHandler(e, task) }}
      onDragEnd={(e) => { dragEndHandler(e) }}
      onDrop={(e) => { dropHandler(e, task) }}
      onDragOver ={(e) => { dragOverHandler(e) }}
      onDragLeave={(e) => { dragLeaveHandler(e) }}
      onClick={(e) => { onClickTaskHandler(e, task) }}
      className='calendar_task_block'
      sx={styles}>
      <span style={{ textOverflow: 'ellipsis', padding: '5px 0 0 5px' }}>
        {task.title}
      </span>
      <ContentCopyIcon sx={{ marginLeft: 'auto', marginTop: '5px' }} onClick={(e) => { e.stopPropagation(); setCopyTask(task) }}>
      </ContentCopyIcon>
    </Box>);
}

export default memo(CalendarWeekTask);