import Paper from '@mui/material/Paper';
import UsersTasksTableToolbar from '../../components/UsersTasksCompoments/UsersTasksTableToolbar/UsersTasksTableToolbar';
import UsersTasksTablePagination from '../../components/UsersTasksCompoments/UsersTasksTablePagination/UsersTasksTablePagination';
import UsersTasksTableContainer from '../../components/UsersTasksCompoments/UsersTasksTableContainer/UsersTasksTableContainer';
import { activateCreateCopyTasksMode, addTaskToUserTasksTable, deleteDateTimeTaskUsers, deleteTaskUsers, editTaskUsers, fetchAllTasksByMembership } from '../../store/actions/tasksActions';
import { shallowEqual, useDispatch, useSelector } from 'react-redux';
import { useCallback, useEffect, useState } from 'react';
import { fetchAllUserProjects } from '../../store/actions/projectsActions';
import moment from 'moment';
import { useNavigate } from 'react-router-dom';

export default function EnhancedTable() {
  const dispatch = useDispatch();
  const navigate = useNavigate()

  const { tasks } = useSelector((state) => state.tasks);
  const { allUserProjectsForModalTask } = useSelector(state => state.projects, shallowEqual)

  const [newTask, setNewTask] = useState({
    priority: '',
    title: '',
    project: '',
    description: '',
    executor: '',
    dateTimeDeadLine: null,
  })

  const [currentTask, setCurrentTask] = useState({
    priority: '',
    title: '',
    project: '',
    description: '',
    executor: '',
    dateTimeDeadLine: null,
  })

  const [order, setOrder] = useState('asc');
  const [orderBy, setOrderBy] = useState('createdAt');
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] = useState(10);
  const [addFormStatus, setAddFormStatus] = useState(false);

  useEffect(() => {
    dispatch(fetchAllTasksByMembership());
    dispatch(fetchAllUserProjects())
  }, [dispatch]);

  const onChangeNewTaskHandler = useCallback((e) => {
    const { value, name } = e.target;
    setNewTask((prevState => {
      return {
        ...prevState,
        [name]: value
      }
    }));
  }, [])

  const onChangeCurrentTaskHandler = useCallback((e) => {
    const { value, name } = e.target;
    setCurrentTask((prevState => {
      return {
        ...prevState,
        [name]: value
      }
    }));
  }, [])

  const onDateChangeEditHandler = useCallback((value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    setCurrentTask((prevState => {
      return {
        ...prevState,
        [property]: utcAvoidoffset
      }
    }));
  }, []);

  const onDateChangeHandler = useCallback((value, property) => {
    const utcAvoidoffset = moment(value).utcOffset(0, true).format()
    setNewTask((prevState => {
      return {
        ...prevState,
        [property]: utcAvoidoffset
      }
    }));
  }, []);

  const handleRequestSort = useCallback((event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  }, [order, orderBy]);

  const handleChangePage = useCallback((event, newPage) => {
    setPage(newPage);
  }, []);

  const handleChangeRowsPerPage = useCallback((event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  }, []);

  const createTaskFromButtonHandler = useCallback(() => {
    if (addFormStatus) {
      setNewTask({
        priority: '',
        title: '',
        project: '',
        description: '',
        executor: '',
        dateTimeDeadLine: null
      })
    }
    setAddFormStatus((prevState) => { return !prevState })
  }, [addFormStatus])

  const createNewTaskHandler = useCallback(() => {
    if (newTask.priority === '' || newTask.project === '' || newTask.executor) {
      const task = {
        ...newTask,
        priority: newTask.priority ? newTask.priority : null,
        project: newTask.project ? newTask.project : null,
        executor: newTask.executor ? newTask.executor : null,
      }
      dispatch(addTaskToUserTasksTable(task))
    } else {
      dispatch(addTaskToUserTasksTable(newTask))
    }
    setNewTask({
      priority: '',
      title: '',
      project: '',
      description: '',
      executor: '',
      dateTimeDeadLine: null
    })
    setAddFormStatus((prevState) => { return !prevState })
  }, [dispatch, newTask])


  const deleteTaskHandler = useCallback((id) => {
    dispatch(deleteTaskUsers(id))
  }, [dispatch])

  const deleteCopyTaskHandler = useCallback((id) => {
    dispatch(deleteDateTimeTaskUsers(id))
  }, [dispatch])

  const calendarOpen = (task) => {
    dispatch(activateCreateCopyTasksMode(task, navigate))
  }

  const editCurrentTaskHandler = useCallback(() => {
    if (currentTask.priority === '' || currentTask.project === '' || currentTask.executor) {
      const task = {
        ...currentTask,
        priority: currentTask.priority ? currentTask.priority : null,
        project: currentTask.project ? currentTask.project : null,
        executor: currentTask.executor ? currentTask.executor : null,
      }
      dispatch(editTaskUsers(task))
    } else {
      dispatch(editTaskUsers(currentTask))
    }
    setCurrentTask({
      priority: '',
      title: '',
      project: '',
      description: '',
      executor: '',
      dateTimeDeadLine: null
    })
  }, [dispatch, currentTask])

  return (
    <Paper sx={{ width: '100%', mb: 2 }}>
      <UsersTasksTableToolbar
        addFormStatus={addFormStatus}
        createTaskFromButtonHandler={createTaskFromButtonHandler}
      />
      <UsersTasksTableContainer
        order={order}
        orderBy={orderBy}
        handleRequestSort={handleRequestSort}
        rows={tasks}
        page={page}
        rowsPerPage={rowsPerPage}
        addFormStatus={addFormStatus}
        onChangeNewTaskHandler={onChangeNewTaskHandler}
        newTask={newTask}
        allUserProjectsForModalTask={allUserProjectsForModalTask}
        onDateChangeHandler={onDateChangeHandler}
        createNewTaskHandler={createNewTaskHandler}
        deleteTaskHandler={deleteTaskHandler}
        calendarOpen={calendarOpen}
        deleteCopyTaskHandler={deleteCopyTaskHandler}
        currentTask={currentTask}
        setCurrentTask={setCurrentTask}
        onChangeCurrentTaskHandler={onChangeCurrentTaskHandler}
        onDateChangeEditHandler={onDateChangeEditHandler}
        editCurrentTaskHandler={editCurrentTaskHandler}
      />
      <UsersTasksTablePagination
        count={tasks.length}
        rowsPerPage={rowsPerPage}
        page={page}
        handleChangePage={handleChangePage}
        handleChangeRowsPerPage={handleChangeRowsPerPage}
      />
    </Paper>
  );
}
