import { AppBar, Box, Typography } from "@mui/material";
import { memo } from "react";
import CreateTaskFromButton from "./CreateTaskFromButton/CreateTaskFromButton";


function UsersTasksTableToolbar({ addFormStatus, createTaskFromButtonHandler }) {

  return (
    <AppBar position="static" sx={{ padding: 3 }}>
      <Box sx={{ display: 'flex', alignItems: 'center' }}>
        <Typography
          sx={{ flex: '1 1 100%' }}
          variant="h6"
          id="tableTitle"
          component="div"
        >
          Задачи сотрудников
        </Typography>
        <CreateTaskFromButton
          addFormStatus={addFormStatus}
          onClick={() => { createTaskFromButtonHandler() }}
        />
      </Box>
    </AppBar>
  );
}

export default memo(UsersTasksTableToolbar)