import React from "react";
import TextField from "@mui/material/TextField";
import { LocalizationProvider } from "@mui/x-date-pickers/LocalizationProvider";
import { DateTimePicker } from "@mui/x-date-pickers/DateTimePicker";
import { AdapterMoment } from "@mui/x-date-pickers/AdapterMoment";
import moment from "moment";





export default function MaterialUIPickers({task, name, onChange }) {
  let fullYear = new Date().getFullYear()
  let month = new Date().getMonth() 
  let day = new Date().getDate();
  return (
    <LocalizationProvider
      dateAdapter={AdapterMoment}
      sx={{ width: "100%", fontSize: 5, fontWeight: "200" }}
      adapterLocale={'ru-RU'}
    >
      <DateTimePicker
      minTime={moment({year:fullYear,month:month,day:day ,hour:11,minute:0})}
      maxTime={moment({year:fullYear,month:month,day:day ,hour:20,minute:0})}
      disablePast={true}
      showTimeSelect={true}
      minutesStep={60}
      ampm={false}
      ampmInClock={false}
        inputFormat="DD/MM/YY HH:mm"
        renderInput={(params) =>{  return (
          <TextField
            {...params}
            sx={{ width: "auto", fontWeight: "200", fontSize: 5 }}
            name={name}
          />
        )}}
        value={task.dateTimeDeadLine}
        onChange={(newValue) => {
          onChange(newValue, name);
        }}
      />
    </LocalizationProvider>
  );
}
