import { Box } from "@mui/material";
import { memo} from "react";
import ColumnTitle from "./ColumnTitle/ColumnTitle";
import UsersList from "./UsersList/UserList";

const styleColumn = {
  border: '3px solid black',
  borderRadius: '10px',
  height: '60vh',
  flexBasis: 70 / 3 + '%',
  overflow: 'auto',
  overflowX: 'hidden',
}


const ProjectUsersColumn = ({ role, members, deleteMemberHandler, currentRoleInProject, dragMemberToNewRole, setCurrentMember }) => {

  return (
    <Box
      sx={styleColumn}

    >
      <ColumnTitle text={role.text} />

      <UsersList
        role={role}
        members={members}
        deleteMemberHandler={deleteMemberHandler}
        currentRoleInProject={currentRoleInProject}
        dragMemberToNewRole={dragMemberToNewRole}
        setCurrentMember={setCurrentMember}
      >
      </UsersList>
    </Box>
  );
};

export default memo(ProjectUsersColumn);