import { Grid } from "@mui/material";
import { Box } from "@mui/system";
import { useCallback, useState } from "react";
import ModalTask from "../../UI/ModalTask/ModalTask";
import CalendarModalTaskContent from "../../UI/CalendarModalTaskContent/CalendarModalTaskContent";
import CalendarRow from "../../UI/CalendarRow/CalendarRow";
import CalendarSmallCell from "../../UI/CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "../../UI/CalendarStandartCell/CalendarStandartCell";
import HourFormatSwitch from "../../UI/HourFormatSwitch/HourFormatSwitch";
import CalendarColumnDayWeek from "./CalendarColumnDayWeek/CalendarColumnDayWeek";
import { getCurrentWeekDayString, getMonthAndYearToDayColumn } from "./Helpers";

function WeekCalendarBody({ week, hoursInDay, hourFormat, setHourFormat, date, tasks, currentTask, setCurrentTask, onChangeCurrentTaskHandler, deleteTaskHandler, sendNewTaskHandler, createTaskInCellHandler, copyTask, setCopyTask, createCopyTask, dragTaskHandler, copyMode }) {
  const [modal, setModal] = useState({ open: false, y: 0, x: 0, });
  const handleOpen = useCallback((e) => {
    setModal({
      open: true,
      yClickСordinates: e.clientY,
      xClickСordinates: e.clientX,
      yDivClick: e.nativeEvent.offsetY,
      xDivClick: e.nativeEvent.offsetX,
      yDiv: e.target.offsetHeight,
      xDiv: e.target.offsetWidth,
    })
  }, []);

  const handleClose = useCallback(() => {
    setModal({ ...modal, open: false })
    setCurrentTask({})
  }, [setCurrentTask, modal]);

  return (
    <>
      <Box style={{ marginBottom: copyMode.working ? '100px' : '30px'}}>
        <Box style={{ position: 'sticky', top: '0px', zIndex: '10', backgroundColor: 'lightgrey' }}>
          <CalendarRow
          >
            <CalendarSmallCell xs={1}>
              <HourFormatSwitch
                hourFormat={hourFormat}
                setHourFormat={setHourFormat}
              />
            </CalendarSmallCell>
            {week?.map((weekDay, i) => {
              return (
                <CalendarStandartCell key={i} xs={11 / week.length}>
                  <span style={{ display: 'block', fontWeight: "600" }}>{weekDay}</span>
                  <span style={{ marginBottom: '10px' }}>{getCurrentWeekDayString(i)}</span>
                </CalendarStandartCell>
              )
            })}
          </CalendarRow>
        </Box>

        <Grid container>
          <CalendarRow week={true}>
            <Grid item xs={0.995} flexDirection='column'>
              {hoursInDay?.map((hour, i) => {
                return (
                  <CalendarSmallCell key={i} week={true}>
                    {hour}
                  </CalendarSmallCell>)
              })}
            </Grid>

            <Grid item xs={11.005}>
              <CalendarRow week={true}>
                {week?.map((weekDay, i) => {
                  const {month, year} = getMonthAndYearToDayColumn(week, weekDay, date.month, date.year)
                  return (
                    <CalendarColumnDayWeek
                      key={i}
                      hoursInDay={hoursInDay}
                      tasks={tasks}
                      month={month}
                      year={year}
                      day={weekDay}
                      hourFormat={hourFormat}
                      setCurrentTask={setCurrentTask}
                      handleOpen={handleOpen}
                      createTaskInCellHandler={createTaskInCellHandler}
                      modal={modal.open}
                      copyTask={copyTask} 
                      setCopyTask={setCopyTask} 
                      createCopyTask={createCopyTask}
                      dragTaskHandler={dragTaskHandler}
                      copyMode={copyMode}
                      deleteTaskHandler={deleteTaskHandler}
                    />
                  )
                })}
              </CalendarRow>
            </Grid>

          </CalendarRow>
        </Grid>
      </Box>

      <ModalTask
        modal={modal}
        handleClose={() => { handleClose() }}
        week={true}
      >
        <CalendarModalTaskContent
          title={currentTask.title}
          description={currentTask.description}
          priority={currentTask.priority}
          id={currentTask.id}
          startHour={currentTask.infoForCell?.startHour}
          endHour={currentTask.infoForCell?.endHour}
          project={currentTask.project}
          onChangeCurrentTaskHandler={(e) => { onChangeCurrentTaskHandler(e) }}
          sendNewTaskHandler={() => { sendNewTaskHandler(); handleClose() }}
          deleteTaskHandler={(e) => { deleteTaskHandler(e, currentTask.id); handleClose() }}
        />
      </ModalTask>
    </>
  );
}

export default WeekCalendarBody;