import axios from "../../axiosPlanner";

import { CHANGE_MEMBER_ROLE_FAILURE, CHANGE_MEMBER_ROLE_REQUEST, CHANGE_MEMBER_ROLE_SUCCESS, CREATE_MEMBER_SUCCESS, CREATE_PROJECT_SUCCESS, DELETE_MEMBER_FAILURE, DELETE_MEMBER_REQUEST, DELETE_MEMBER_SUCCESS, DELETE_PROJECT_FAILURE, DELETE_PROJECT_REQUEST, DELETE_PROJECT_SUCCESS, FETCH_ALL_USER_PROJECTS_SUCCESS, FETCH_PROJECTS_ERROR, FETCH_PROJECTS_REQUEST, FETCH_PROJECTS_SUCCESS, FETCH_PROJECT_SUCCESS } from "../actionTypes/projectsActionTypes";
import { showNotification } from "./commonActions";

const fetchProjectsRequest = () => {
    return { type: FETCH_PROJECTS_REQUEST }
};
const fetchProjectsSuccess = (projects) => {
    return { type: FETCH_PROJECTS_SUCCESS, projects };
};
const fetchProjectsError = (error) => {
    return { type: FETCH_PROJECTS_ERROR, error };
}
const fetchProjectSuccess = (project) => {
    return { type: FETCH_PROJECT_SUCCESS, project };
};

const createProjectSuccess = () => {
    return { type: CREATE_PROJECT_SUCCESS };
};

const createMemberSuccess = (member) => {
    return { type: CREATE_MEMBER_SUCCESS, member };
};

const deleteMemberRequest = () => {
    return { type: DELETE_MEMBER_REQUEST }
};

const deleteMemberSuccess = () => {
    return { type: DELETE_MEMBER_SUCCESS }
};

const deleteMemberFailure = (error) => {
    return { type: DELETE_MEMBER_FAILURE, error }
};

const deleteProjectRequest = () => {
    return { type: DELETE_PROJECT_REQUEST }
};

const deleteProjectSuccess = () => {
    return { type: DELETE_PROJECT_SUCCESS }
};

const deleteProjectFailure = (error) => {
    return { type: DELETE_PROJECT_FAILURE, error }
};
export const deleteMember = (memberId, projectId) => {
    return async (dispatch) => {
        dispatch(deleteMemberRequest());
        try {
            await axios.delete(`/projects/remove-user/${memberId}`, {data: {projectId: projectId}});
            dispatch(deleteMemberSuccess())
            await dispatch(fetchProject(projectId))
        } catch (error) {
            dispatch(deleteMemberFailure(error.response.data));
        }
    }
}

export const deleteProject = (projectId, projects) => {
    return async (dispatch) => {
        dispatch(deleteProjectRequest());
        try {
            const response = await axios.delete('/projects', { data: { projectId: projectId } });
            console.log("deleteMember ", response.data)
            dispatch(deleteProjectSuccess())
            dispatch(fetchProjects(projects))
        } catch (error) {
            dispatch(deleteProjectFailure(error.response.data));
        }
    }
}
export const fetchProjects = () => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/my");
            dispatch(fetchProjectsSuccess(response.data));
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    };
};

export const fetchProject = (id) => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/" + id);
            dispatch(fetchProjectSuccess(response.data));
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    }
};

export const createProject = (projectData, navigate) => {
    return async (dispatch) => {
        try {
            const response = await axios.post("/projects", projectData);
            dispatch(createProjectSuccess());
            console.log(response.data)
            navigate("/projects/" + response.data.project.id)
            dispatch(showNotification("Проект успешно создан"))
        } catch (e) {
            console.log(e);
            dispatch(showNotification("Не удалось создать проект", "error"))
        }
    };
}

export const createMember = (memberData) => {
    return async (dispatch) => {
        dispatch(fetchProjectsRequest());
        try {
            await axios.post("/projects/add-user", memberData);
            dispatch(createMemberSuccess());
            await dispatch(fetchProject(memberData?.projectId))
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    };
}

const fetchAllUserProjectsSuccess = (projects) => {
    return { type: FETCH_ALL_USER_PROJECTS_SUCCESS, projects };
};

export const fetchAllUserProjects = () => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/my");
            dispatch(fetchAllUserProjectsSuccess(response.data.projects));
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    }
}

const changeMemberRoleFailure = (error) => {
    return { type:  CHANGE_MEMBER_ROLE_FAILURE, error }
};

const changeMemberRoleRequest = () => {
    return { type:  CHANGE_MEMBER_ROLE_REQUEST }
};

const changeMemberRoleSuccess = () => {
    return { type:  CHANGE_MEMBER_ROLE_SUCCESS }
};

export const changeMemberRole = (userId, data) => {
    return async (dispatch) => {
        dispatch(changeMemberRoleSuccess());
        try {
            const response = await axios.put(`/projects/change-project-role/${userId}`, data);
            console.log(response.data)
            dispatch(changeMemberRoleRequest());
            await dispatch(fetchProject(data?.projectId))
        } catch (e) {
            dispatch(changeMemberRoleFailure(e));
        }
    }
}

