import { Box } from "@mui/material";
import { memo } from "react";
import { projectRoles } from "../../../constants";
import ProjectUsersColumn from "./ProjectUsersColumn/ProjectUsersColumn";


const style = {
  display: 'flex',
  gap: '150px',
  width: '100%',
  marginTop: '20px',
  justifyContent: 'space-evenly'
}


const ProjectUsersColumnsWrapper = ({ members, deleteMemberHandler, currentRoleInProject, dragMemberToNewRole, setCurrentMember}) => {
  return (
    <Box sx={style} justifyContent={'space-between'}>
      {projectRoles.map((role, i) => {
        return (
          <ProjectUsersColumn
            key={i}
            role={role}
            members={members}
            deleteMemberHandler={deleteMemberHandler}
            currentRoleInProject={currentRoleInProject}
            dragMemberToNewRole={dragMemberToNewRole}
            setCurrentMember={setCurrentMember}
          />
        )
      })}
    </Box>
  );
};

export default memo(ProjectUsersColumnsWrapper);