import { Button } from "@mui/material";
import { memo } from "react";
import { projectRoles } from "../../../constants";
import CustomAutocomplete from "../../UI/CustomAutocomplete/CustomAutocomplete";
import { isValidate } from "./helpers";



function NewMemberModalContent({ members, users, onChangeNewMemberHandler, onChangeRoleHandler, newMember, handleClose, createNewMemberHandler }) {
  return (<>
    <CustomAutocomplete
      name={'newMember'}
      label={'Новый участник'}
      options={users}
      onChange={onChangeNewMemberHandler}
      value={newMember?.userId}
      getOptionLabel={(item) => item.displayName || ""}
      style={{ marginBottom: '15px' }}
    />

    <CustomAutocomplete
      name={'role'}
      label={'Роль'}
      options={projectRoles}
      onChange={onChangeRoleHandler}
      value={newMember?.roleProject}
      getOptionLabel={(item) => item.text || ""}
      style={{ marginBottom: '15px' }}
    />
    <div style={{ display: 'flex', justifyContent: 'space-between', margin: '10px 0' }}>
      <Button onClick={() => { createNewMemberHandler() }} disabled={!isValidate(members, newMember?.userId, newMember?.roleProject)}>Выбрать</Button>
      <Button onClick={() => handleClose()}>Отмена</Button>
    </div>

  </>);
}

export default memo(NewMemberModalContent);