import * as React from "react";
import TableCell from "@mui/material/TableCell";
import Input from "@mui/material/Input";
import moment from "moment";

const CustomTableCell = ({
  task,
  name,
  value,
  value2,
  onChange,
  onModalOpen,
  placeholder,
  user,
  width,
}) => {
  const styles = { width: width, padding: "1px 16px 1px 1px" };
  const inputStyles = placeholder
    ? { width: "100%", padding: "1px" }
    : { padding: "1px" };

  const divStyle = {
    display: "flex",
    justifyContent: "space-between",
    flexDirection: "column",
    fontSize: "12px",
  };
  // if (name==='dateTimeDeadLine'){
  //   console.log('dateTimeDeadLine ', name, ' ', value)
  // }

  const divTwoStyle = {
    display: "flex",
    flexDirection: "row",
    fontSize: "12px",
  };

  const duration = moment.duration(
    moment(task?.dateTimeTasks[0]?.dateTimeDue).diff(
      moment(task?.dateTimeTasks[0]?.dateTimeStart)
    )
  );
  const hours = Math.round(duration.asHours());

  if (task) {
    return (
      <>
        <TableCell 
          onClick={(e) => (onModalOpen ? onModalOpen(e, task) : null)}
          align="left"
          style={styles}
        >
          {(task.isEditMode &&
            onChange &&
            name !== "author" &&
            task.author?.id === user?.id) ||
          placeholder ? (
            <Input
              placeholder={placeholder}
              value={value}
              name={name}
              onChange={(e) => onChange(e, task)}
              style={inputStyles}
            />
          ) : name !== "dateTimeStart" ? (
            <span>{value}</span>
          ) :name === "dateTimeDeadLine"&& value==='Invalid date' ? 
          <span>''</span>
          :(
            <div style={divStyle}>
              <div style={divTwoStyle}>  
              <span title={
                moment(task.dateTimeTasks[0]?.dateTimeStart) 
                .utc()
                .format("DD/MM/YY")}
                >{value}</span> <span> &nbsp;</span>
              <span>({value2})</span></div>
              <span>часы:{hours}</span>
            </div>
          )}
        </TableCell>
      </>
    );
  }
};

export default CustomTableCell;
