import {Button, Menu, MenuItem} from "@mui/material";
import { useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import {NavLink, useNavigate} from "react-router-dom";
import { fetchUsersAllFields, logoutUser } from "../../../store/actions/usersActions";
import SwitchUserModal from "../../SwitchUserModal/SwitchUserModal";
import HasAccess from "../../UI/HasAccess/HasAccess";

const ProfileBlock = () => {
  const dispatch = useDispatch();
    const navigate = useNavigate()
    const [anchorEl, setAnchorEl] = useState(null);
    const open = Boolean(anchorEl);
    const user = useSelector(state => state.users.user)

    const [openSwitchUser, setOpenSwitchUser] = useState(false);
    const handleCloseSwitchUser = () => setOpenSwitchUser(false);
 
    const handleClick = (event) => {
        setAnchorEl(event.currentTarget);
    };
    const handleClose = () => {
        setAnchorEl(null);
    };

    const handleOpenSwitchUser = () => setOpenSwitchUser(true);

    const logout = () => {
        dispatch(logoutUser(navigate));
        handleClose()
    }
    const switchUser=()=>{
        dispatch(fetchUsersAllFields());
        handleClose()
        handleOpenSwitchUser()
    }
    const navigateToRegisterUser =()=>{
        navigate('/sign-up')
        handleClose()
    }



  return <>
      <Button
            color="inherit"
            onClick={handleClick}
            id='test_greetings'
        >
            Привет, {user?.displayName}
        </Button>
        <Menu
            anchorEl={anchorEl}
            open={open}
            onClose={handleClose}

        >
            <MenuItem component={NavLink} to="/profile/test" color="inherit" onClick={handleClose}>Профиль</MenuItem>
            <MenuItem onClick={()=>{switchUser()}}>Поменять юзера</MenuItem>
            <HasAccess roles={['superuser']}>
                <MenuItem onClick={()=>{navigateToRegisterUser()}}>Создать сотрудника</MenuItem>
            </HasAccess>
            <MenuItem onClick={()=>{logout()}}>Выйти</MenuItem>
        </Menu>
        <SwitchUserModal 
        open={openSwitchUser}
        handleClose={handleCloseSwitchUser} 
        />
  </>
};

export default ProfileBlock;