import { Box } from '@mui/system';
import { TextField, Typography } from '@mui/material';
import { memo, useCallback, useState } from 'react';

function WeekPriority({ number, priority, onChangeWeekPrioritiesHandler, priorityName }) {
  const [priorityEditCheck, setPriorityEditCheck] = useState(false)
  const onClickPriorityHandler = useCallback(() => {
    setPriorityEditCheck(true)
  }, [])
  return (
    <>
      <Box sx={{ display: 'flex', alignItems: 'center', gap: '10px' }}>
        {priorityEditCheck ?
          <>
            <Typography variant='string'>
              {number}.
            </Typography>
            <TextField
              id={priorityName}
              value={priority}
              variant="standard"
              sx={{ input: { color: 'white', fontSize: '22px', fontWeight: '400'} }}
              InputProps={{
                disableUnderline: true,
              }}
              name={priorityName}
              autoFocus
              onBlur={() => { setPriorityEditCheck(false) }}
              onChange={(e) => { onChangeWeekPrioritiesHandler(e) }}
            />

          </>
          : <Typography variant='string' onClick={() => { onClickPriorityHandler() }}>{number}. {priority}</Typography>
        }
      </Box>
    </>
  );
}

export default memo(WeekPriority);