import { Box } from "@mui/material"
import { useEffect, useState, memo, useCallback, useMemo } from "react"
import { getColorTaskByPriority } from "../../../../../../helpers/CalendarHelpers"
import CopyIcon from "../../../../UI/CopyIcon/CopyIcon";
import DeleteIcon from "../../../../UI/DeleteIcon/DeleteIcon";


function CalendarWeekTask({ height, width, left, top, task, zIndex, handleOpen, setCurrentTask, modal, setCopyTask, month, dragTaskHandler, step, hourFormat, tasksLength, copyModeTask, deleteTaskHandler }) {
  const [zIndexStyle, setZIndexStyle] = useState(10)
  const color = useMemo(() => {
    return getColorTaskByPriority(task.priority)
  }, [task.priority])

  useEffect(() => {
    if (!modal) {
      setZIndexStyle(zIndex)
    }
  }, [modal, zIndex])

  const onClickTaskHandler = useCallback((e, task) => {
    e.stopPropagation();
    setCurrentTask((prevState) => {
      return {
        ...task,
        infoForCell: {
          ...task.infoForCell,
          endHour: task.infoForCell.endHour + 1,
          month: month
        }
      }
    });
    setZIndexStyle(100)
    handleOpen(e)
  }, [handleOpen, setCurrentTask, month])

  const styles = {
    boxSizing: 'border-box',
    borderRadius: '3px',
    border: '1px solid white',
    backgroundColor: color,
    height: `${height - 1}px`,
    width: `${width - 1}px`,
    position: 'absolute',
    display: 'flex',
    left: left,
    top: top,
    zIndex: zIndexStyle,
    textAlign: 'left',
    overflow: 'hidden',
    transition: '0.2s',
    textOverflow: 'ellipsis',
    '&:hover': {
      transition: '0.2s',
      cursor: 'pointer',
      boxShadow: 'inset 0 0 100px 100px rgba(255, 255, 255, 0.3)'
    },
  }

  const dragStartHandler = (e, task) => {
    setCurrentTask((prevState) => {
      return {
        ...task,
        infoForCell: {
          ...task?.infoForCell,
          month: month
        }
      }
    });
  }

  const dragEndHandler = (e) => {
    e.target.style.boxShadow = 'none'
  }

  const dragOverHandler = (e) => {
    e.preventDefault();
  }

  const dropHandler = (e, task) => {
    e.preventDefault();
    let hour
    if (hourFormat) {
      hour = task.infoForCell.startHour + (Math.ceil(e.nativeEvent.offsetY / step) - 1)
    } else {
      hour = task.infoForCell.startHour + (Math.ceil(e.nativeEvent.offsetY / step) - 1 + Math.ceil(e.nativeEvent.offsetY / step) - 1)
    }
    dragTaskHandler(task.infoForCell.startDay, hour, task.infoForCell.startMonth - 1, task.infoForCell.startYear)
  }

  const dragLeaveHandler = (e) => {
    e.preventDefault();
  }

  const onClickCopyIconHandler = useCallback((e) => {
    e.stopPropagation();
    setCopyTask(task)
  }, [task, setCopyTask])

  const returnTask = useMemo(() => {
    if (copyModeTask?.id === task?.mainTaskId) {
      return (<>
        <span style={{ textOverflow: 'ellipsis', padding: '5px 0 0 5px' }}>
          {task.title}
        </span>
        <DeleteIcon
          onClick={(e) => { deleteTaskHandler(e, task.id) }}
        />
      </>)
    }
    if (tasksLength > 2) {
      return (<>
        <CopyIcon
          tasksLength={tasksLength}
          onClick={(e) => { onClickCopyIconHandler(e) }}
        />
        <span style={{ textOverflow: 'ellipsis', padding: '5px 0 0 5px' }}>
          {task.title}
        </span>
      </>)
    } else {
      return (<>
        <span style={{ textOverflow: 'ellipsis', padding: '5px 0 0 5px' }}>
          {task.title}
        </span>
        <CopyIcon
          onClick={(e) => { onClickCopyIconHandler(e) }}
        />
      </>)
    }
  }, [tasksLength, task.title, onClickCopyIconHandler, copyModeTask?.id, deleteTaskHandler, task?.id, task?.mainTaskId])

  return (
    <Box
      draggable={true}
      onDragStart={(e) => { dragStartHandler(e, task) }}
      onDragEnd={(e) => { dragEndHandler(e) }}
      onDrop={(e) => { dropHandler(e, task) }}
      onDragOver={(e) => { dragOverHandler(e) }}
      onDragLeave={(e) => { dragLeaveHandler(e) }}
      onClick={(e) => { onClickTaskHandler(e, task) }}
      className='calendar_task_block'
      sx={styles}>
      {returnTask}
    </Box>);
}

export default memo(CalendarWeekTask);