import {getDaysInMonth, getCurrentMonthString, dateToISOLikeButLocal, getAvailableTasks, getSortedTasks} from '../helpers/CalendarHelpers';

describe('Получение дней в феврале 2022', () => {
  test('Всего дней', () => {
      expect(getDaysInMonth({year:2022, month:1}).length).toBe(28);
  })
  test('Первый день', () => {
    expect(getDaysInMonth({year:2022, month:1})[0]).toEqual({dayNumber: 1, dayOfWeek: 'ВТ'});
  })
  test('Последний день', () => {
    expect(getDaysInMonth({year:2022, month:1})[27]).toEqual({dayNumber: 28, dayOfWeek: 'ПН'});
  })
  test('Неккоретное значение выше нормы', () => {
    expect(getDaysInMonth({year:2022, month:12})).toBe(null);
  })
  test('Неккоретное значение ниже нормы', () => {
    expect(getDaysInMonth({year:2022, month:-1})).toBe(null);
  })
})

describe('Получение дней в ноябре 2022', () => {
  test('Всего дней', () => {
      expect(getDaysInMonth({year:2022, month:10}).length).toBe(30);
  })
  test('Первый день', () => {
    expect(getDaysInMonth({year:2022, month:10})[0]).toEqual({dayNumber: 1, dayOfWeek: 'ВТ'});
  })
  test('Последний день', () => {
    expect(getDaysInMonth({year:2022, month:10})[29]).toEqual({dayNumber: 30, dayOfWeek: 'СР'});
  })
})

describe('Получение месяца', () => {
  test('Первый месяц', () => {
      expect(getCurrentMonthString(0)).toBe("Январь");
  })
  test('Последний месяц', () => {
    expect(getCurrentMonthString(11)).toBe("Декабрь");
  })
  test('Неккоретное значение выше нормы', () => {
    expect(getCurrentMonthString(12)).toBe(null);
  })
  test('Неккоретное значение ниже нормы', () => {
    expect(getCurrentMonthString(-1)).toBe(null);
  })
})

describe('Получение ISO даты', () => {
  test('Валидная дата', () => {
      expect(dateToISOLikeButLocal(new Date(2021, 11, 28, 5, 59))).toBe("2021-12-28T05:59:00.000Z");
  })
  test('Не валидная дата', () => {
    expect(dateToISOLikeButLocal(new Date(2021, 'sd', 28, 5, 59))).toBe(null);
  })
})

describe('Получение допустимых задач для клетки', () => {
  test('Валидные задачи', () => {
    expect(getAvailableTasks([{infoForCell: {startYear: 2022, startMonth: 12, startDay: 12}}, {infoForCell: {startYear: 2022, startMonth: 12, startDay: 12}}], 2022, 11, 12).length).toBe(2);
  })
  test('Не валидные задачи', () => {
    expect(getAvailableTasks([{infoForCell: {startYear: 2021, startMonth: 11, startDay: 12}}, {infoForCell: {startYear: 2022, startMonth: 12, startDay: 14}}], 2022, 11, 12).length).toBe(0);
  })
  test('Не все прошедшие проверку задачи', () => {
    expect(getAvailableTasks([{infoForCell: {startYear: 2021, startMonth: 11, startDay: 12}}, {infoForCell: {startYear: 2022, startMonth: 12, startDay: 12}}], 2022, 11, 12).length).toBe(1);
  })
})

describe('Получение сортированных задач', () => {
  test('Сортировка прошла успешно Вариант№1', () => {
    const tasks = [
      {
        infoForCell: {
          startHour: 12, 
          endHour: 14
        }
      }, 
      {
        infoForCell: {
          startHour: 13, 
          endHour: 14
        }
      }]
    expect(getSortedTasks(tasks)).toEqual(tasks)
  })
  test('Сортировка прошла успешно Вариант№2', () => {
    const tasks = [
      {
        infoForCell: {
          startHour: 12, 
          endHour: 14
        }
      }, 
      {
        infoForCell: {
          startHour: 10, 
          endHour: 14
        }
      }]
    expect(getSortedTasks(tasks)).toEqual(tasks.reverse())
  })
  test('Сортировка прошла успешно Вариант№3', () => {
    const tasks = [
      {
        infoForCell: {
          startHour: 12, 
          endHour: 14
        }
      }, 
      {
        infoForCell: {
          startHour: 10, 
          endHour: 14
        }
      },
      {
        infoForCell: {
          startHour: 11, 
          endHour: 12
        }
      }]
    expect(getSortedTasks(tasks)).toEqual([tasks[1], tasks[0], tasks[2]])
  })
})