import { accomplishStatuses } from "../../constants";
import {
  ADD_NEW_TASK_FAILURE,
  ADD_NEW_TASK_REQUEST,
  ADD_NEW_TASK_SUCCESS,
  EDIT_TASK_FAILURE,
  EDIT_TASK_REQUEST,
  EDIT_TASK_SUCCESS,
  FETCH_CALENDAR_TASKS_FAILURE,
  FETCH_CALENDAR_TASKS_REQUEST,
  FETCH_CALENDAR_TASKS_SUCCESS,
  DELETE_TASK_SUCCESS,
  DELETE_TASK_REQUEST,
  DELETE_TASK_FAILURE,
  FETCH_ALL_TASKS_SUCCESS,
  FETCH_TASKS_BY_PROJECT_REQUEST,
  FETCH_TASKS_BY_PROJECT_SUCCESS,
  FETCH_TASKS_BY_PROJECT_FAILURE,
  DELETE_DATETIMETASK_FAILURE,
  DELETE_DATETIMETASK_SUCCESS,
  DELETE_DATETIMETASK_REQUEST,
  FETCH_ALL_TASKS_BY_MEMBERSHIP_SUCCESS,
  ACTIVATE_CREATE_COPY_TASKS_MODE,
  DEACTIVATE_CREATE_COPY_TASKS_MODE,
  SORT_TASKS
} from "../actionTypes/tasksTypes";

const initialState = {
  copyMode: {
    working: false,
    task: null,
  },
  tasks: [],
  calendarTasks: [],
  sortedTasks: [],
  loading: false,
  error: null,
};

const tasksReduсer = (state = initialState, action) => {
  switch (action.type) {
    case FETCH_CALENDAR_TASKS_REQUEST:
      return { ...state, loading: true };
    case FETCH_CALENDAR_TASKS_SUCCESS:
      const newTasksWithoutInfoForCell = []
      const newTasksWithInfoForCell = []
      for (let task of action.tasks) {
        for (let copy of task.dateTimeTasks) {
          newTasksWithoutInfoForCell.push({
            ...copy,
            project: task?.project,
            mainTaskId: task.id,
            executor: task.executor,
            author: task.author,
            dateTimeDeadLine: task.dateTimeDeadLine,
            priority: task.priority,
            title: task.title,
            description: task.description
          })
        }
      }
      newTasksWithoutInfoForCell.forEach((task) => {
        if (task.dateTimeStart && task.dateTimeDue) {
          if (new Date(task.dateTimeDue).getTime() - new Date(task.dateTimeStart).getTime() < (24 * 3600000) &&
            new Date(task.dateTimeDue).getTime() - new Date(task.dateTimeStart).getTime() > 0) {
            const dateStart = task.dateTimeStart.split('T')[0]
            const timeStart = task.dateTimeStart.split('T')[1]
            const timeEnd = task.dateTimeDue.split('T')[1]
            const dayStart = parseInt(dateStart.split('-')[2])
            const monthStartNumber = parseInt(dateStart.split('-')[1])
            const yearStartNumber = parseInt(dateStart.split('-')[0])
            const timeStartHour = parseInt(timeStart.split(':')[0])
            const timeEndHour = parseInt(timeEnd.split(':')[0])
            const timeStartMinute = parseInt(timeStart.split(':')[1])
            const timeEndMinute = parseInt(timeEnd.split(':')[1])
            const newObj = {
              ...task,
              infoForCell: {
                startDay: dayStart,
                startHour: timeStartHour,
                startMonth: monthStartNumber,
                startYear: yearStartNumber,
                startMinute: timeStartMinute,
                endHour: timeEndHour,
                endMinute: timeEndMinute,
              }
            }
            newTasksWithInfoForCell.push(newObj)
          }
        }
      })
      return { ...state, loading: false, calendarTasks: newTasksWithInfoForCell };
    case FETCH_ALL_TASKS_SUCCESS:
      const newArrTasks = action.tasks.map((task)=>{
        return {
        ...task,
        authorName: task.author.displayName,
        projectTitle: task.project.title,
        accomplishTranslate: accomplishStatuses.find((status) => {
          if (status.value === task.accomplish) {
            return status
          }
          return null
        }).text
      }})
      return { ...state, loading: false, tasks: newArrTasks , projects: action.projects };
    case FETCH_ALL_TASKS_BY_MEMBERSHIP_SUCCESS:
      const newArr = action.tasks.map((task)=>{
        return {
        ...task,
        authorName: task.author.displayName,
        projectTitle: task.project.title,
        executorName: task?.executor?.displayName || null,
        accomplishTranslate: accomplishStatuses.find((status) => {
          if (status.value === task.accomplish) {
            return status
          }
          return null
        }).text
      }})
      return { ...state, loading: false, tasks: newArr, projects: action.projects };
    case FETCH_CALENDAR_TASKS_FAILURE:
      return { ...state, loading: false, error: action.error };
    case ADD_NEW_TASK_SUCCESS:
      return { ...state, loading: false };
    case ADD_NEW_TASK_REQUEST:
      return { ...state, loading: true };
    case ADD_NEW_TASK_FAILURE:
      return { ...state, loading: false, error: action.error };
    case FETCH_TASKS_BY_PROJECT_SUCCESS:
      return { ...state, loading: false, tasks: action.tasks };
    case FETCH_TASKS_BY_PROJECT_REQUEST:
      return { ...state, loading: true };
    case FETCH_TASKS_BY_PROJECT_FAILURE:
      return { ...state, loading: false, error: action.error };
    case EDIT_TASK_SUCCESS:
      return { ...state, loading: false };
    case EDIT_TASK_REQUEST:
      return { ...state, loading: true };
    case EDIT_TASK_FAILURE:
      return { ...state, loading: false, error: action.error };
    case DELETE_TASK_SUCCESS:
      return { ...state, loading: false };
    case DELETE_TASK_REQUEST:
      return { ...state, loading: true };
    case DELETE_TASK_FAILURE:
      return { ...state, loading: false, error: action.error };
    case DELETE_DATETIMETASK_SUCCESS:
      return { ...state, loading: false };
    case DELETE_DATETIMETASK_REQUEST:
      return { ...state, loading: true };
    case DELETE_DATETIMETASK_FAILURE:
      return { ...state, loading: false, error: action.error };
    case ACTIVATE_CREATE_COPY_TASKS_MODE:
      return { ...state, copyMode: { working: true, task: action.task } }
    case DEACTIVATE_CREATE_COPY_TASKS_MODE:
      return { ...state, copyMode: { working: false, task: null } }
    case SORT_TASKS:
      let filteredTasks = []
      if (action.activeTasksOn) {
        filteredTasks = state.tasks.filter(task=>task.accomplish==='opened' || task.accomplish==='progress')
      }
      if (action.projectIdListForTaskSelect.length) {
        if (filteredTasks.length) {
          filteredTasks = filteredTasks.filter(task=>action.projectIdListForTaskSelect.includes(task.project?.id)) 
        } else {
          filteredTasks = state.tasks.filter(task=>action.projectIdListForTaskSelect.includes(task.project?.id)) 
        }
      }
      return { ...state, loading: false, sortedTasks: filteredTasks };
    default:
      return state;
  }
};

export default tasksReduсer;