import { Button, Grid} from "@mui/material";
import { NavLink } from "react-router-dom";
import FormElement from "../UI/Form/FormElement/FormElement";

const ResetPasswordForm = ({ state, onChange, onSubmit, getFieldError, buttonText }) => {
    return <form onSubmit={onSubmit}>
        <Grid container spacing={2}>
            <FormElement
                onChange={onChange}
                name="email"
                label="Enter your email address"
                state={state}
                error={getFieldError?.("email")}
            />
        </Grid>
        <Button
            sx={{ mt: "15px" }}
            type="submit"
            fullWidth
            variant="contained"
            color="primary"
        >
            {buttonText}
        </Button>
    </form>
}

export default ResetPasswordForm;