import { Box, TableCell, TableHead, TableRow, TableSortLabel } from "@mui/material";
import { visuallyHidden } from '@mui/utils';
import { memo } from "react";

const headCells = [
  {
    id: "priority",
    label: "Приоритет",
    canSort: true,
    style: {
      width: '4%'
    }
  },
  {
    id: "createdAt",
    label: "Дата создания",
    canSort: true,
    style: {
      width: '10%'
    }
  },
  {
    id: "title",
    label: "Заголовок",
    canSort: true,
    style: {
      width: '28%'
    }
  },
  {
    id: "projectTitle",
    label: "Проект",
    canSort: true,
    style: {
      width: '12%'
    }
  },
  {
    id: "authorName",
    label: "Автор",
    canSort: true,
    style: {
      width: '11%'
    }
  },
  {
    id: "dateTimeStart",
    label: "Дата и время выполнения",
    canSort: false,
    style: {
      width: '15%'
    }
  },
  {
    id: "dateTimeDeadLine",
    label: "Дедлайн",
    canSort: true,
    style: {
      width: '10%'
    }
  },
  {
    id: "accomplishTranslate",
    label: "Статус",
    canSort: true,
    style: {
      width: '7%'
    }
  },
  {
    id: "buttons",
    label: "",
    canSort: false,
    style: {
      width: '5%'
    }
  },
];

function MyTasksTableHead({ order, orderBy, handleRequestSort }) {
  const createSortHandler = (property) => (event) => {
    handleRequestSort(event, property);
  };

  return (
    <TableHead>
      <TableRow>
        {headCells.map((headCell) => (
          <TableCell
            key={headCell.id}
            sortDirection={orderBy === headCell.id ? order : false}
            sx={headCell.style}
          >
            {headCell.canSort ? <TableSortLabel
              active={orderBy === headCell.id}
              direction={orderBy === headCell.id ? order : 'asc'}
              onClick={createSortHandler(headCell.id)}
            >
              {headCell.label}
              {orderBy === headCell.id ? (
                <Box component="span" sx={visuallyHidden}>
                  {order === 'desc' ? 'sorted descending' : 'sorted ascending'}
                </Box>
              ) : null}
            </TableSortLabel> : headCell.label}

          </TableCell>
        ))}
      </TableRow>
    </TableHead>
  );
}

export default memo(MyTasksTableHead)