import { Grid } from "@mui/material";
import { useCallback, useEffect, useState } from "react";
import { useDispatch, useSelector } from "react-redux";
import { createProject, deleteProject, fetchProjects } from "../../store/actions/projectsActions";
import FullProject from "../FullProject/FullProject";
import ProjectsWrapper from "../../components/ProjectsComponents/ProjectsWrapper/ProjectsWrapper";
import { useNavigate } from "react-router-dom";
import DefaultModal from "../../components/UI/DefaultModal/DefaultModal";
import NewProjectModalContent from "../../components/ProjectsComponents/NewProjectModalContent/NewProjectModalContent";

const Projects = () => {
    const { projects } = useSelector(state => state.projects.projects);
    const { user } = useSelector(state => state.users)

    const dispatch = useDispatch();
    const navigate = useNavigate()

    const [currentProject, setCurrentProject] = useState(null)
    const [projectTitle, setProjectTitle] = useState('');
    const [modal, setModal] = useState(false)

    useEffect(() => {
        dispatch(fetchProjects())
    }, [dispatch]);

    const inputChangeHandler = (e) => {
        setProjectTitle(e.target.value)
    };

    const onClickProjectHandler = useCallback((project) => {
        setCurrentProject(project)
    }, [])

    const createNewProjectHandler = useCallback(() => {
        dispatch(createProject({ title: projectTitle, user: user.id }))
        setModal(false)
    }, [dispatch, projectTitle, user.id])

    const deleteProjectHandler = useCallback((e, projectId) => {
        e.stopPropagation();
        dispatch(deleteProject(projectId))
    }, [dispatch])

    const handleOpen = useCallback(async () => {
        setModal(true)
    }, [])

    const handleClose = useCallback(() => {
        setModal(false)
    }, [])


    console.log(currentProject)

    return <>
        <Grid container justifyContent='space-between'>

            <ProjectsWrapper
                projects={projects}
                onClickProjectHandler={onClickProjectHandler}
                handleOpen={handleOpen}
                deleteProjectHandler={deleteProjectHandler}
            />

            <Grid item xs={7}  >
                {currentProject ? <FullProject projectId={currentProject?.id ? currentProject?.id : null} /> : null}
            </Grid>

        </Grid>

        <DefaultModal
            modal={modal}
            handleClose={() => { handleClose() }}
        >
            <NewProjectModalContent
                handleClose={handleClose}
                projectTitle={projectTitle}
                inputChangeHandler={inputChangeHandler}
                createNewProjectHandler={createNewProjectHandler}
            />
        </DefaultModal>
    </>
};

export default Projects;