// import 'express-async-errors';
// import expressAsyncErrors from 'express-async-errors';
import express, { NextFunction, Request, Response } from "express";
import { myDataSource } from "./app-data-source";
import { Task } from "./models/Task";
import { User } from "./models/User";
import nodemailer from  'nodemailer';
import { Member } from "./models/Member";


const dataSource = myDataSource;

/** Check if user with given token exists , return user */
export const auth = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    if(!token) return res.status(401).send({Message:'token not exists'})
    const user = await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .where("user.token = :token", { token: token })
    .getOne();
    if (!user) return res.status(404).send({Message:'user not found'})
    req.body={...req.body,user:user}
    next()
};

/**Check if user with the given token is executor or author of task with the given Id(taskId) */
export const authAuthorOrExecutorOfTask = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    const {user} = req.body
    let taskId = null
    if (req.body?.taskId) {
        taskId = req.body.taskId
    } else if (req.params?.taskId){
        taskId = req.params.taskId
    } else return res.send({vessage:"there are no taskId found"})

    if(!token) return res.status(401).send({Message:'token not exists'})
    req.body={...req.body,executorStatus:false}
    req.body={...req.body,authorStatus:false}
    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,
            dateTimeTasks: true,           
        },
        where:
            {
            id:taskId,
        }
    })
    if (!task) return res.status(404).send({message:'task with possible user involved is not found'})
    if(task.author?.id===user.id) {
        req.body={...req.body,authorStatus:true}
    } 
    if (task.executor?.id===user.id){
        req.body={...req.body,executorStatus:true}
    }
    const {executorStatus, authorStatus} = req.body 
    if (!executorStatus && !authorStatus) {
        return res.status(403).send({message:'user is not authorized'})
    }
    req.body={...req.body, task:task}
    next()
}; 


/**Check if user with the given token is executor or author of task with the given dateTimeTaskId */
export const authAuthorOrExecutorOfDateTimeTask = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    let dateTimeTaskId = null
    req.body={...req.body,executorStatus:false}
    req.body={...req.body,authorStatus:false}
    dateTimeTaskId = req.body.dateTimeTaskId
    if (req.body?.dateTimeTaskId) { 
        dateTimeTaskId = req.body.dateTimeTaskId
    } else if (req.params?.dateTimeTaskId){
        dateTimeTaskId = req.params.dateTimeTaskId
    } else return res.send({vessage:"there are no dateTimeTaskId found"})
    const task =await dataSource
    .getRepository(Task)
    .findOne({
        relations:
        {
            dateTimeTasks: true,
            executor:true,
            author:true,
        },
        where:{
            dateTimeTasks:
            {
                id:dateTimeTaskId
            }
    }})
    if (!task) return res.status(404).send({message:'task with possible user involved is not found'})
    req.body={...req.body, task:task}
    if(task?.executor?.token === token) {
        req.body={...req.body,executorStatus:true}
    }
      if (task?.author?.token === token ) {
        req.body={...req.body,authorStatus:true}
    }
    if (req.body.authorStatus ===false && req.body.executorStatus===false) return  res.status(403).send({Message:'user is not uathorized'})
    next()
}


/**check if user is admin of the project, receives userId and projectId*/
export const authAdminProject = async(req: Request,res: Response, next:NextFunction):Promise<void | express.Response<Response>>=>{
    const token = req.get('Authorization');
    const {projectId} = req.body;
    const adminOfProject =  await dataSource
    .createQueryBuilder()
    .select("user")
    .from(User, "user")
    .leftJoinAndSelect("user.members","member")
    .leftJoinAndSelect('member.project', 'project' )
    .where("user.token = :token", { token })
    .andWhere('project.id=:projectId',{projectId})
    .andWhere('member.roleProject=:roleProject',{roleProject:'admin'})
    .getOne()
    if (!adminOfProject){
        return res.send({message:'User is not authorized'})
    } 
    req.body ={...req.body,adminStatus:true}
    next()
}


/**task finder by id, return one task */
export const taskFinderById = async (taskId:string):Promise<null | Task>=>{
    const task = await dataSource
    .getRepository(Task)
    .findOne({
        relations:{
            executor:true,
            author:true,
            dateTimeTasks:true
        },
        where:{
            id:taskId
        }
    }) 
    return task
}

/** find task by dateTimeTaskId */
export const taskFinderByDateTimeTaskId = async (dateTimeTaskId:string):Promise<null | Task>=>{
    const task =await dataSource
    .getRepository(Task)
    .findOne({
        relations:
        {
            dateTimeTasks: true
        },
        where:{
            dateTimeTasks:
            {
                id:dateTimeTaskId
            }
    }})
   return task
}


/**member finder by userId and projectId, return one task */
export const memberFinderById = async (userId:string, projectId:string):Promise<Member|null>=>{
    const member = await dataSource
    .getRepository(Member)
    .findOne({
        relations:{
            user:true,
            project:true,
        },
        where:{
            user:{
                id : userId
            },
            project:{
                id:projectId
            }
        }
    })

    return member
}


export const  transporter = nodemailer.createTransport({
    service:'Yandex',
    // host: "smtp.yandex.ru",
    // port: 465,
    // secure: true, // true for 465, false for other ports
    auth: {
      user: "planner45@yandex.ru", // generated ethereal user
      pass: "newPlannerProject123" // generated ethereal password
    }
  })


  export const subtractHours= (date:Date, hours:number)=> {
    const dateCopy = new Date(date);
    dateCopy.setHours(dateCopy.getHours() - hours);
    return dateCopy;
  }


  export let frontend_url  = 'localhost:3000';
  if (process.env.REACT_APP_NODE_ENV === "dev") {
    frontend_url = "http://116.203.144.156:3000"
  }

