import { Box, Button, Grid, Modal } from "@mui/material";
import { useState } from "react";
import { useSelector, useDispatch } from "react-redux";
import { Typography } from "@mui/material";
import TextField from '@mui/material/TextField';
import Autocomplete from '@mui/material/Autocomplete';
import { useParams } from "react-router-dom";
import PersonAddIcon from '@mui/icons-material/PersonAdd';
import { useEffect } from "react";
import { fetchProject } from "../../store/actions/projectsActions";

const style = {
  position: 'relative',
  top: '50%',
  left: '50%',
  transform: 'translate(-50%, -50%)',
  width: 400,
  bgcolor: 'background.paper',
  border: '2px solid #000',
  boxShadow: 24,
  p: 4,
};

const MemberForm = ({ onSubmit, members }) => {
  const users = useSelector(state => state.users.users)
  const [role, setRole] = useState([{ role: "user" }, { role: "admin" }, { role: "watcher" }])
  const params = useParams()
  const dispatch = useDispatch();

  const [open, setOpen] = useState(false);
  const handleOpen = () => setOpen(true);
  const handleClose = () => setOpen(false);
  const [state, setState] = useState({
    roleProject: "",
    user: "",
    projectId: ""
  });


  const submitFormHandler = (e) => {
    e.preventDefault();
    let members = { roleProject: state.roleProject, projectId: params.id, userId: state.user.id }
    console.log(members);
    onSubmit(members);
    setOpen(false);
  };
  console.log(state);

  useEffect(() => {
    dispatch(fetchProject(params.id))
  }, [params]);


  const memberChangeHandler = (e, value) => {
    setState(() => { return { ...state, user: value, projectId: params.id } });
    console.log("memberChangeHandler" + value)
  }
  const roleChangeHandler = (e, value) => {
    setState(() => { return { ...state, roleProject: value } });
    console.log(value)
  }
  return (
    <div >
      <PersonAddIcon onClick={handleOpen} style={{ marginLeft: "30px", marginTop: "-3px", cursor: 'pointer' }} >Добавить участника</PersonAddIcon>
      <Modal
        open={open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"

      >
        <Box sx={style}>
          <form onSubmit={submitFormHandler}>
            <Grid container direction="column" spacing={2}>
              <Typography variant="h5" style={{ margin: "5px", textAlign: "center" }} >Новый участник</Typography>
              <Autocomplete
                id="free-solo-demo"
                freeSolo
                options={users}
                getOptionLabel={(item) => item.displayName || ""}
                onChange={memberChangeHandler}
                name={"userId"}
                value={state.user}
                renderInput={(params) => <TextField
                  style={{ margin: "5px" }}
                  label={"Участник"}
                  state={state}
                  {...params} />}
              />
              <Autocomplete
                id="free-solo-demo"
                freeSolo
                options={role?.map((role) => role.role)}
                value={state.roleProject}
                onChange={roleChangeHandler}
                renderInput={(params) => <TextField
                  style={{ margin: "5px" }}
                  name={"roleProject"}
                  label={"Роль в проекте"}
                  state={state}
                  {...params} />}
              />
              <Grid item>
                <Button
                  type="submit"
                  color="primary"
                  variant="contained"
                >
                  Create
                </Button>
              </Grid>
            </Grid>
          </form>
        </Box>
      </Modal>
    </div>
  );

};

export default MemberForm;