import { useMemo } from "react";
import { getHoursInDayNumbers, getAvailableTasks, getLinesInDay, getSortedTasks } from "../../../../../helpers/CalendarHelpers";
import CalendarStandartCell from "../../../CalendarStandartCell/CalendarStandartCell";

function CalendarRowDayWeek({ hoursInDay, tasks, month, year, day, hourFormat }) {
  const hours = useMemo(() => {
    return getHoursInDayNumbers(hoursInDay)
  }, [hoursInDay])

  const availableTasks = useMemo(() => {
    return getAvailableTasks(tasks, year, month, day)
  }, [tasks, month, year, day])

  const sortedTasks = useMemo(() => {
    return getSortedTasks(availableTasks)
  }, [availableTasks])

  const linesInDay = useMemo(() => {
    return getLinesInDay(availableTasks, sortedTasks, hoursInDay, hours, hourFormat)
  }, [availableTasks, hourFormat, hours, hoursInDay, sortedTasks])

  return (<>
    {hoursInDay?.map((hour, i) => {
      return (
        <CalendarStandartCell key={i} week={true}>

        </CalendarStandartCell>)
    })}

  </>);
}

export default CalendarRowDayWeek;