import { AppBar, Button, Toolbar, Typography } from '@mui/material';
import { Box } from '@mui/system';
import MonthAndYearInfo from './MonthAndYearInfo/MonthAndYearInfo';

function MonthCalendarHeader({ currentMonthString, decrementMonth, incrementMonth, year, handleOpen, currentCalendarDisplayName, user, userId}) {

  return (
    <>
      <Box sx={{ flexGrow: 1 }}>
        <AppBar position="static">
          <Toolbar>

            <Box>
              <Typography variant="h5" sx={{ margin: "20px 0 20px 0" }}>
                Календарь:  {currentCalendarDisplayName}
              </Typography>
              <MonthAndYearInfo
                currentMonthString={currentMonthString}
                decrementMonth={decrementMonth}
                incrementMonth={incrementMonth}
                year={year}
              />
            </Box>
            <Button
              onClick={() => { handleOpen() }}
              color="inherit"
              size="large"
              sx={{ marginLeft: 'auto' }}
            >
              {user.id === userId ? 'Выбрать сотрудника' : 'Вернуться назад'}
            </Button>
          </Toolbar>
        </AppBar>
      </Box>
    </>
  );
}

export default MonthCalendarHeader;