import * as React from 'react';
import PropTypes from 'prop-types';
import Box from '@mui/material/Box';
import TableCell from '@mui/material/TableCell';
import TableHead from '@mui/material/TableHead';
import TableRow from '@mui/material/TableRow';
import TableSortLabel from '@mui/material/TableSortLabel';
import { visuallyHidden } from '@mui/utils';


const headCells = [
  {
    id: 'id',
    numeric: true,
    disablePadding: true,
    label: '',
  },
  {
    id: 'priority',
    numeric: false,
    disablePadding: true,
    label: 'Приоритет',
  },
  {
    id: 'date',
    numeric: true,
    disablePadding: false,
    label: 'Дата создания',
  },
  {
    id: 'task',
    numeric: true,
    disablePadding: false,
    label: 'Задача',
  },
  {
    id: 'author',
    numeric: true,
    disablePadding: false,
    label: 'Автор',
  },
  
  {
    id: 'startDate',
    numeric: true,
    disablePadding: false,
    label: 'Дата начала',
  },
  {
    id: 'endDate',
    numeric: true,
    disablePadding: false,
    label: 'Дата завершения',
  },
  {
    id: 'done',
    numeric: true,
    disablePadding: false,
    label: 'Статус',
  },
  {
    id: 'change',
    numeric: false,
    disablePadding: false,
    label: '',
  },
  {
    id: 'delete',
    numeric: false,
    disablePadding: false,
    label: '',
  },
];

export default function EnhancedTableHead(props) {
  const {  order, orderBy, rowCount, onRequestSort } =
    props;
  const createSortHandler = (property) => (event) => {
    onRequestSort(event, property);
  };

  return (
    <TableHead>
      <TableRow>
       
        {headCells.map((headCell) => (
          <TableCell
            key={headCell.id}
            align={'center'}
            padding={headCell.disablePadding ? 'none' : 'normal'}
            sortDirection={orderBy === headCell.id ? order : false}
          >
            <TableSortLabel
              active={orderBy === headCell.id}
              direction={orderBy === headCell.id ? order : 'asc'}
              onClick={createSortHandler(headCell.id)}
            >
              {headCell.label}
              {orderBy === headCell.id ? (
                <Box component="span" sx={visuallyHidden}>
                  {order === 'desc' ? 'sorted descending' : 'sorted ascending'}
                </Box>
              ) : null}
            </TableSortLabel>
          </TableCell>
        ))}
      </TableRow>
    </TableHead>
  );
}

EnhancedTableHead.propTypes = {
  onRequestSort: PropTypes.func.isRequired,
  order: PropTypes.oneOf(['asc', 'desc']).isRequired,
  orderBy: PropTypes.string.isRequired,
  rowCount: PropTypes.number.isRequired,
};

