import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TablePagination,
  TableRow,
  Paper,
  IconButton,
  Tooltip,
  } from "@mui/material";
import { useState, useEffect } from "react";
import {useDispatch, useSelector} from "react-redux";
import { Done, Edit } from "@mui/icons-material";
import DeleteIcon from "@mui/icons-material/Delete";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import EnhancedTableHead from "./MyTasksHeader/MyTasksHeader";
import moment from "moment";
import MyTaskToolBar from '../../components/MyTasksCompoments/MyTaskToolBar';
import CustomTableCell from "../../components/MyTasksCompoments/CustomTableCell";
import MaterialUIPickers from "../../components/MyTasksCompoments/DateTimePicker/DateTimePicker";
import MaterialUIPickersDue from "../../components/MyTasksCompoments/DateTimePicker/DateTimePickerDue";
import BasicSelect from "../../components/UI/Select/Select";
import { fetchAllTasks} from "../../store/actions/tasksActions";
import { deleteTask } from "../../store/actions/tasksActions";

function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === 'desc'
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}


function stableSort(array, comparator) {
  const stabilizedThis = array.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}


export default function EnhancedTable() {

  const [order, setOrder] = React.useState('asc');
  const [orderBy, setOrderBy] = React.useState('id');
   const [page, setPage] = React.useState(0);
   const [rowsPerPage, setRowsPerPage] = React.useState(5);
  const [newStartedDate, setNewStartedDate] = React.useState();
  const [newDueDate, setNewDueDate] = React.useState();
  const [readOnly, setReadOnly]=React.useState(true);

  const handleChange = (id, newDate) => {
    setNewStartedDate({ id: id, date: newDate });

  };

  const dispatch = useDispatch();

  useEffect(() => {
      dispatch(fetchAllTasks ());
}, []);
const tasks = useSelector(state => state.tasks.tasks);
console.log(tasks)

  // const [tasks,setTasks]=useState([
  // {
  //   user:"first",
  //   title:"Р·Р°РґР°С‡Р°1",
  //   description:"РѕРїРёСЃР°РЅРёРµ Р·Р°РґР°С‡Рё11111",
  //   priority:"A",
  //   author:"Ivan",
  //   executor:"Arman",
  //   dateTimeStart: "2022-10-26T11:00:00",
  //     dateTimeDue: "2022-10-27T10:30:00",
  //   id:1,
  //   createdAt:"26.10.2022",
  //   accomplish:" "
  // },
  // {
  //     title:"Р·Р°РґР°С‡Р°2",
  //     description:"РѕРїРёСЃР°РЅРёРµ Р·Р°РґР°С‡Рё222222",
  //     author:"Ivan",
  //     executor:"Elena",
  //     priority:"B",
  //     dateTimeStart: "2022-10-26T13:30:00",
  //     dateTimeDue: "2022-10-27T12:30:00",
  //     id:2,
  //     createdAt:"26.10.2022",
  //     accomplish:" "
  //   },
  //   {
  //     id:3,
  //     title:"Р·Р°РґР°С‡Р°3",
  //     description:"РѕРїРёСЃР°РЅРёРµ Р·Р°РґР°С‡Рё333333bjh,khkuhlhvilv hmgjtycikg mkgyxxkjfkkmgyhkfrdtseygdtjtuliuo8plfyvguh,bb",
  //     createdAt:"27.10.2022",
  //     dateTimeStart: "2022-10-30T09:30:00",
  //     dateTimeDue: "2022-11-02T09:30:00",
  //     accomplish:" ",
  //     author:"Artem",
  //     project:"Project1",
  //     executor:"Bota",
  //     priority:"B",
  //   }
  // ])
  

  useEffect(() => {
    if (newStartedDate) {
     
      let updatedTasks = [...tasks].filter((t) => t.id !== newStartedDate.id);
      const currentTask = tasks.find((t) => t.id === newStartedDate.id);
      delete currentTask.dateTimeStart;
  
      const updatedTask = {
        ...currentTask,
        dateTimeStart: moment.parseZone(newStartedDate.date, 'DD/MM/YYYY', true).format(),
            };
      updatedTasks.push(updatedTask);
      tasks=updatedTasks;
    }
  }, [newStartedDate]);

  useEffect(() => {
    if (newDueDate) {
      let updatedTasks = [...tasks].filter((t) => t.id !== newDueDate.id);
      const currentTask = tasks.find((t) => t.id === newDueDate.id);
      delete currentTask.dateTimeDue;
      console.log(newDueDate.date)
      const updatedTask = {
        ...currentTask,
        dateTimeDue: moment.parseZone(newDueDate.date, 'DD/MM/YYYY', true).format()
      };
      updatedTasks.push(updatedTask);
      tasks=updatedTasks; 
    }
   }, [newDueDate]);

  const onToggleEditMode = id => {
    if (readOnly==true) {setReadOnly(false)} else {setReadOnly(true)}
   
      return tasks.map(task => {
        if (task.id === id) {
          return { ...task, isEditMode: !task.isEditMode };
        }
        
        return task;
      });
    
  };


  const onToggleEditModeDone = id => {
    if (readOnly==true) {setReadOnly(false)} else {setReadOnly(true)}
  
      return tasks.map(task => {
        if (task.id === id) {
             return { ...task, isEditMode: !task.isEditMode };
        }
        return task;
      });
   
    
  };
  
  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = tasks.map(task => {
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });
    tasks=newTasks;
  };

  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === 'asc';
    setOrder(isAsc ? 'desc' : 'asc');
    setOrderBy(property);
  };
  
  const deleteHandle=(id)=>{
     dispatch(deleteTask(id))
  };

  const handleChangePage = (event, newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };
  
  const [modal, setModal] =useState({
    open: false,
    task: null
  });
  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, task});
  };
  const handleClose = () => {
    setModal({ ...modal, open: false, task: null });
  };
 
  const addTask=()=>{
  let newTasks=[...tasks]
  newTasks.unshift(
    {
      title:"",
      description:"",
      priority:"",
      author:"",
      executor:"",
      dateTimeStart:"",
      dateTimeDue:"",
      id:4,
      createdAt:"",
      accomplish:" "
    }
   )
  tasks=newTasks;
  };

 if (tasks)
  {return (
    <Box sx={{ width: 'fullwidth' }}>
      <Paper sx={{ width: '100%', mb: 2 }}>

      <MyTaskToolBar
       onClick={()=>{addTask()}}
      />

        <TableContainer>
       
          <Table
            sx={{ minWidth: 600 }}
            aria-labelledby="tableTitle"
          >
            <EnhancedTableHead
              order={order}
              orderBy={orderBy}
              onRequestSort={handleRequestSort}
              rowCount={tasks.length}
            />
            <TableBody>

              {stableSort(tasks, getComparator(order, orderBy))
                .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                .map((task, index) => {
                
                  return (
               
                    <TableRow
                      hover
                      key={task.id}                    
                    >
                      
                     <TableCell
                        component="th"
                        scope="row"
                        padding="none"
                      ></TableCell>  
                        <CustomTableCell {...{ task, name: "priority", onChange }} />
                        <CustomTableCell {...{ task, name: "createdAt", onChange }} />
                        <CustomTableCell {...{ task, name: "title", onChange, onModalOpen}}  />
                        <CustomTableCell {...{ task, name: "author.displayName", onChange }} />
                      
                        <TableCell key={task.id} >
                          <MaterialUIPickers
                          newStartedDate={newStartedDate}
                          task={task}
                          setNewStartedDate={setNewStartedDate}
                          readOnly={readOnly}
                          />
                       </TableCell>
                       <TableCell key={task.id}>
                            <MaterialUIPickersDue
                            newDueDate={newDueDate}
                            task={task}
                            setNewDueDate={setNewDueDate}
                            readOnly={readOnly}
                            />
                        </TableCell>
                        <CustomTableCell {...{ task, name: "accomplish", onChange }} />
                 
                       {/* <BasicSelect
                       itemOne={"open"}
                       itemTwo={"done"}
                       itemThree={"failed"}
                       task={task}
                       />          */}

                      <TableCell >
               
                {task.isEditMode ? (
                 
                    <IconButton
                      aria-label="done"
                      onClick={() => onToggleEditModeDone(task.id)}
                    >
                      <Done/>
                    </IconButton>
                     
                ) : (
                  <IconButton
                    aria-label="delete"
                    onClick={() => onToggleEditMode(task.id)}
                  >
                    <Edit/>
                  </IconButton>
                )}
              </TableCell>
                     <TableCell>
                      <Tooltip title="Delete">
                      <IconButton onClick={(id)=>{deleteHandle(task.id)}}>
                        <DeleteIcon />
                      </IconButton>
                      </Tooltip>
                    </TableCell>
                    </TableRow>
                    
                  );
                })}
           
            </TableBody>
          </Table>
        </TableContainer>
        <TablePagination
          rowsPerPageOptions={[5,10, 25]}
          component="div"
          count={tasks.length}
          rowsPerPage={rowsPerPage}
          page={page}
          onPageChange={handleChangePage}
          onRowsPerPageChange={handleChangeRowsPerPage}
        />
      </Paper>
        <TaskModal
          task={modal.task}
          open={modal.open}
          handleClose={handleClose}
          onChange={(e) => {onChange(e,modal.task)}}  
          onToggleEditMode={onToggleEditMode} 
          tasks={tasks}  
          // setTasks={setTasks}      
        /> 
    </Box>
  )};
}
