import { AppBar, FormControl, InputLabel, MenuItem, Select, Toolbar, Typography } from '@mui/material';
import ArrowBackIcon from '@mui/icons-material/ArrowBack';
import ArrowForwardIcon from '@mui/icons-material/ArrowForward';
import { Box } from '@mui/system';

const arrowClass = {
  borderRadius: '50%',
  cursor: 'pointer',
  transition: '0.5s',
  "&:hover": { 
  
  background: 'rgb(48, 154, 252, 0.65)',
  transition: '0.5s',
  transform: 'scale(1.2)'
  }
}


function MonthCalendarHeader({month, getCurrentMonthString, decrementMonth, incrementMonth, calendarType, onChangeWorkerHandler, onChangeCalendarTypeHandler, worker, year}) {
  
  return (
    <>
        <Box sx={{ flexGrow: 1 }}>
          <AppBar position="static">
            <Toolbar>
              <Box
                sx={{ 
                  flexGrow: 1, 
                  display: 'flex',
                  alignItems: 'center',
                  gap: '10px'
                }}
                >
                  <ArrowBackIcon
                    onClick={()=>{decrementMonth()}}
                    sx={arrowClass}
                  />
                  <Box sx={{ flexBasis: '150px' }}>
                  <Typography
                    variant="h6" 
                    sx={{  
                      display: 'flex',
                      justifyContent: 'center',
                    }}
                  >
                    {getCurrentMonthString(month)}
                  </Typography>
                  <Typography align='center'>{year}</Typography>
                  </Box>
                  <ArrowForwardIcon
                    sx={arrowClass}
                    onClick={()=>{incrementMonth()}}
                  />     
              </Box>

              <FormControl variant="standard" sx={{ m: 1, minWidth: 120 }}>
                <InputLabel id="worker-select-label">Сотрудник</InputLabel>
                <Select
                  labelId="worker-select-label"
                  id="worker-select"
                  value={worker}
                  onChange={(e)=>{onChangeWorkerHandler(e)}}
                  label="Worker"
                >
                  <MenuItem value="">
                    <em>-- Выберите сотрудника --</em>
                  </MenuItem>
                  <MenuItem value={"Василий"}>Василий</MenuItem>
                  <MenuItem value={"Никита"}>Никита</MenuItem>
                  <MenuItem value={"Артем"}>Артем</MenuItem>
                </Select>
              </FormControl>

              <FormControl variant="standard" sx={{ m: 1, minWidth: 120 }}>
                <InputLabel id="calendar-type-label">Календарь</InputLabel>
                <Select
                  labelId="calendar-type-label"
                  id="calendar-type"
                  value={calendarType}
                  onChange={(e)=>{onChangeCalendarTypeHandler(e)}}
                  label="Type"
                >
                  <MenuItem value={"Месяц"}>Месяц</MenuItem>
                  <MenuItem value={"Неделя"}>Неделя</MenuItem>
                </Select>
              </FormControl>

            </Toolbar>
          </AppBar>
        </Box>
    </>
  );
}

export default MonthCalendarHeader;