import { Grid, TextField, Typography } from "@mui/material";
import { useEffect, useState } from "react";

const CalendarStandartCell = ({children, xs, currentTask, hours, dayNumber,  createTaskInCellHandler, handleOpen, modal}) => {
    const [isThisCell, setIsThisCell] = useState(false)
    useEffect(()=>{
        if(!modal) {
            setIsThisCell(false);
        }
    }, [modal])
    return <>
        <Grid  
            item xs={xs} 
            sx={{borderRight: '1px solid black'}} 
            onClick={(e)=>{createTaskInCellHandler(dayNumber, hours); setIsThisCell(true); handleOpen(e)}}>
            {children}
        {isThisCell ?  
        <Grid
            sx={{backgroundColor: 'lightgreen', padding: '10px', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis'}} 
        >
            <span>
                {currentTask.title}
            </span>
        </Grid> : null}
        </Grid>
    </>
};

export default CalendarStandartCell;