import moment from 'moment';
import { useEffect, useState, useMemo, useCallback  } from 'react';
import WeekCalendarBody from '../../components/WeekCalendar/WeekCalendarBody/WeekCalendarBody';
import WeekCalendarHeader from '../../components/WeekCalendar/WeekCalendarHeader/WeekCalendarHeader'
import { getWeekInfoString, getWeekFromCurrentDate } from '../../helpers/CalendarHelpers';


function WeekCalendar() {

  const [date, setDate] = useState({year: '', month: '', currentDay: ''})
  const [hourFormat, setHourFormat] = useState(false);

  useEffect(()=>{
    const year = new Date().getFullYear()
    const month = new Date().getMonth()
    const currentDay = moment().date()
    setDate({year: year, month: month, currentDay: currentDay})
  }, [])

  const hoursInDay = useMemo(()=>{
    let arr
    if (hourFormat) {
      arr = ['8:00', '9:00', '10:00', '11:00', '12:00', '13:00', '14:00', '15:00', '16:00', '17:00', '18:00', '19:00', '20:00','21:00','22:00']
    } else {
      arr = ['8:00', '10:00', '12:00', '14:00', '16:00', '18:00', '20:00', '22:00']
    }
    return arr
  }, [hourFormat])

  const week = useMemo(()=>{
    return getWeekFromCurrentDate(date.year, date.month, date.currentDay)
  }, [date])

  const incrementWeek = useCallback(() => {
    setDate((prevState)=>{
      const newDate = new Date(prevState.year, prevState.month, prevState.currentDay + 7)
      return {year: newDate.getFullYear(), month: newDate.getMonth(), currentDay: moment(newDate).date()}
    })
  }, [])

  const decrementWeek = useCallback(() => {
    setDate((prevState)=>{
      const newDate = new Date(prevState.year, prevState.month, prevState.currentDay - 7)
      return {year: newDate.getFullYear(), month: newDate.getMonth(), currentDay: moment(newDate).date()}
    })
  }, [])

  const weekInfo = useMemo(()=>{
    return getWeekInfoString(week, date)
  }, [date, week])
  
  return (
    <>
      <WeekCalendarHeader
        incrementWeek={incrementWeek}
        decrementWeek={decrementWeek}
        weekInfo={weekInfo}
      />
      <WeekCalendarBody
        week={week}
        hourFormat={hourFormat}
        setHourFormat={setHourFormat}
        hoursInDay={hoursInDay}
      />
    </>
  );
}

export default WeekCalendar;