import { FormControlLabel, Grid, Switch } from "@mui/material";
import { Box } from "@mui/system";
import CalendarRow from "../../MonthCalendar/MonthCalendarBody/CalendarRow/CalendarRow";
import CalendarSmallCell from "../../MonthCalendar/MonthCalendarBody/CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "../../MonthCalendar/MonthCalendarBody/CalendarStandartCell.js/CalendarStandartCell";
import CalendarRowDayWeek from "./CalendarRowDayWeek/CalendarRowDayWeek";
import { getCurrentWeekDayString } from "./Helpers";

function WeekCalendarBody({week, hoursInDay, hourFormat, setHourFormat,}) {
  
  return (
    <>
        <Box style={{marginBottom: '30px'}}>
          <Box style={{position: 'sticky', top: '0px', zIndex: '10', backgroundColor: 'lightgrey'}}>
            <CalendarRow
                    >
                <CalendarSmallCell xs={1}> 
                <FormControlLabel
                    control={<Switch color="primary" checked={hourFormat} onChange={()=>{setHourFormat(()=>!hourFormat)}}/>}
                    label="1 час"
                    labelPlacement="end"
                  />
                </CalendarSmallCell>
                {week?.map((weekDay, i)=>{
                  return (
                    <CalendarStandartCell key={i} xs={11/week.length}>
                      <span style={{display: 'block', fontWeight: "600"}}>{weekDay}</span>
                      <span style={{marginBottom: '10px'}}>{getCurrentWeekDayString(i)}</span>
                    </CalendarStandartCell>
                    ) 
                  })}
            </CalendarRow>
          </Box>

          <Grid container>
          <CalendarRow week={true}>
            <Grid item xs={0.995} flexDirection='column'>
              {hoursInDay?.map((hour, i)=>{
                return (
                  <CalendarSmallCell key={i} week={true}>
                    {hour}
                  </CalendarSmallCell>)
              })}
            </Grid>

            <CalendarRowDayWeek
              week={week}
              hoursInDay={hoursInDay}
            />

          </CalendarRow>
          </Grid>
        </Box>
    </>
  );
}

export default WeekCalendarBody;