import * as React from "react";
import {
  Box,
  Table,
  TableBody,
  TableCell,
  TableContainer,
  TablePagination,
  TableRow,
  Paper,
  IconButton,
  Tooltip,
  
} from "@mui/material";
import { useState, useEffect } from "react";
import { useDispatch, useSelector } from "react-redux";
import { Done, Edit } from "@mui/icons-material";
import DeleteIcon from "@mui/icons-material/Delete";
import TaskModal from "../../components/MyTasksCompoments/TaskModal/TaskModal";
import EnhancedTableHead from "./MyTasksHeader/MyTasksHeader";
import moment from "moment";
import MyTaskToolBar from "../../components/MyTasksCompoments/MyTaskToolBar";
import CustomTableCell from "../../components/MyTasksCompoments/CustomTableCell";
import MaterialUIPickers from "../../components/MyTasksCompoments/DateTimePicker/DateTimePicker";
import BasicSelect from "../../components/UI/Select/Select";
import { fetchAllTasks, deleteTask,editTask} from "../../store/actions/tasksActions";
import NewTaskForm from "../../components/MyTasksCompoments/NewTaskForm";



export default function EnhancedTable() {

  const dispatch = useDispatch();

  const tasks = useSelector((state) => state.tasks.tasks);
  
  const [recievedTasks, setRecievedTasks] = useState([]);
  const [addTaskForm, setAddTaskForm] = useState(false);
  const [order, setOrder] = useState("asc");
  const [orderBy, setOrderBy] = useState("id");
  const [page, setPage] = useState(0);
  const [rowsPerPage, setRowsPerPage] =useState(5);
  const [modal, setModal] = useState({
    open: false,
    task: null,
  });
  const [projects,setProjects]=useState(['1','2'])
  console.log(tasks)


  useEffect(() => {
    dispatch(fetchAllTasks());
    filterProjectsNamesFromTasks()
    if (tasks && tasks?.length > 0) {
      setRecievedTasks(tasks);
      }
}, [tasks===undefined,tasks?.length]);

useEffect(() => {
  dispatch(fetchAllTasks());
}, [addTaskForm, setAddTaskForm]);


  const handleRequestSort = (event, property) => {
    const isAsc = orderBy === property && order === "asc";
    setOrder(isAsc ? "desc" : "asc");
    setOrderBy(property);
  };

  const handleChangePage = (event, newPage) => {
    setPage(newPage);
  };

  const handleChangeRowsPerPage = (event) => {
    setRowsPerPage(parseInt(event.target.value, 10));
    setPage(0);
  };

  const onChange = (e, task) => {
    const value = e.target.value;
    const name = e.target.name;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      console.log(task)
      if (task.id === id) {
        return { ...task, [name]: value };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onAuthorChange = (e, task) => {
    const value = e.target.value;
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.author.displayName = value;
        updated.authorDisplayName = value;
        return updated;
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onDateChange = (id, value, property) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          [property]: moment.parseZone(value, "DD/MM/YYYY", true).format(),
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };
  
  const onProjectChange = (e, task) => {
    const value = e.target.value;
    const project = rawProjects.find((e) => e.id === value);
    const { id } = task;
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        const updated = { ...task };
        updated.project = project;
        updated.projectName = project.title;
        return updated;
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };


  const onToggleEditMode = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: true,
          readOnly: false,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const onToggleEditModeDone = (id) => {
    const newTasks = recievedTasks.map((task) => {
      if (task.id === id) {
        return {
          ...task,
          isEditMode: false,
          readOnly: true,
        };
      }
      return task;
    });
    setRecievedTasks(newTasks);
  };

  const handleEditTask= (task)=>{
     dispatch(editTask(task))
  }

  const deleteHandle = (id) => {
    dispatch(deleteTask(id));
  };

 
  const onModalOpen = (event, task) => {
    event.stopPropagation();
    setModal({ ...modal, open: true, id: task.id });
  };

  const handleClose = () => {
    setModal({ ...modal, open: false, id: null });
  };
  // ++++++++фильтрация по проектам+++++++++++++++

  const [projectName, setProjectName] = React.useState([]);
  const [filterProjectTumbler, setFilterProjectTumbler] = React.useState(false);


  const onClose=(projectName)=>{
    let tasksFilteredByProject = tasks
    if (projectName.length>0) {
      tasksFilteredByProject = tasks.filter(task=>projectName.includes(task.project?.title)) 
    }
    setRecievedTasks(tasksFilteredByProject)
    setFilterProjectTumbler(true)
  }
  const rawProjects= tasks?.map(task=>task.project)
  const filterProjectsNamesFromTasks = ()=>{
    if (tasks && tasks?.length > 0) {
    
      let rawSetProjectNames = []
      for (let project of rawProjects){
        if (project===null){
        } else{
          rawSetProjectNames.push(project.title)
        }
      }
      let uniqueTitlesProjects = [...new Set(rawSetProjectNames)];
      setProjects(uniqueTitlesProjects)
      
    }
  }

  if (
    tasks &&
    tasks?.length > 0 &&
    recievedTasks &&
    recievedTasks?.length > 0
  ) {
    return (
      <Box sx={{ width: "fullwidth" }}>
        <Paper sx={{ width: "100%", mb: 2 }}>
          <MyTaskToolBar
            onClick={() => setAddTaskForm(!addTaskForm)}
            formStatus={addTaskForm}
            projects={projects}
            onClose={onClose}
            projectName={projectName}
            setProjectName={setProjectName}
          />

         {addTaskForm ? (
            <NewTaskForm
              tasks={recievedTasks}
              projects={rawProjects}
              setAddTaskForm={()=>setAddTaskForm(false)}
            />
          ) : null}


          <TableContainer>
            <Table sx={{ minWidth: 600 }} aria-labelledby="tableTitle">
              <EnhancedTableHead
                order={order}
                orderBy={orderBy}
                onRequestSort={handleRequestSort}
                rowCount={tasks.length}
              />
              <TableBody>
               
                {stableSort(recievedTasks, getComparator(order, orderBy))
                  .slice(page * rowsPerPage, page * rowsPerPage + rowsPerPage)
                  .map((task, index) => {
                    return (

                      <TableRow hover key={task.id}>
                        <TableCell
                          component="th"
                          scope="row"
                          padding="none"
                        ></TableCell>
                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "A", title: "A" },
                                { value: "B", title: "B" },
                                { value: "C", title: "C" },
                              ]}
                              task={task}
                              value={task.priority}
                              onChange={onChange}
                              name="priority"
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "priority",
                              value: task.priority,
                            }}
                          />
                        )}

                        <CustomTableCell
                          {...{
                            task,
                            name: "createdAt",
                            value: moment(task.createdAt)
                              .utc()
                              .format("DD-MM-YYYY hh:mm A"),

                          }}
                        />

                        <CustomTableCell
                          {...{
                            task,
                            name: "title",
                            value: task.title,
                            onChange,
                            onModalOpen,
                          }}
                        />
                       
                       {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={rawProjects.map((e) => ({
                                value: e?.id,
                                title: e?.title,
                              }))}
                              task={task}
                              onChange={onProjectChange}
                              name="project"
                              value={task.project?.id}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "projectId",
                              value: task.project?.title,
                            }}
                          />
                        )}

                        <CustomTableCell
                          {...{
                            task,
                            name: "author",
                            value: task.author.displayName,
                            onChange: onAuthorChange,
                          }}
                        />

                        <TableCell>
                          <MaterialUIPickers
                            task={task}
                            name="dateTimeStart"
                            onChange={onDateChange}
                          />
                        </TableCell>

                        <TableCell>
                          <MaterialUIPickers
                            task={task}
                            name="dateTimeDue"
                            onChange={onDateChange}
                          />
                        </TableCell>

                        {task.isEditMode ? (
                          <TableCell>
                            <BasicSelect
                              items={[
                                { value: "opened", title: "opened" },
                                { value: "done", title: "done" },
                                { value: "failed", title: "failed" },
                              ]}
                              task={task}
                              onChange={onChange}
                              name="accomplish"
                              value={task.accomplish}
                            />
                          </TableCell>
                        ) : (
                          <CustomTableCell
                            {...{
                              task,
                              name: "accomplish",
                              value: task.accomplish,
                            }}
                          />
                        )}

                        <TableCell>
                          <Tooltip title="Редактировать">
                            {task.isEditMode ? (
                              <IconButton
                                aria-label="done"
                                onClick={() => {
                                  onToggleEditModeDone(task.id);
                                  handleEditTask(task);
                                }}
                              >
                                <Done />
                              </IconButton>
                            ) : (
                              <IconButton
                                aria-label="edit"
                                onClick={() => onToggleEditMode(task.id)}
                              >
                                <Edit />
                              </IconButton>
                            )}
                          </Tooltip>
                        </TableCell>
                        <TableCell>
                          <Tooltip title="Удалить">
                            <IconButton
                              onClick={(id) => {
                                deleteHandle(task.id);
                              }}
                            >
                              <DeleteIcon />
                            </IconButton>
                          </Tooltip>
                        </TableCell>
                      </TableRow>
                    );
                  })}
              </TableBody>
            </Table>
          </TableContainer>
          <TablePagination
            rowsPerPageOptions={[5, 10, 25]}
            component="div"
            count={tasks.length}
            rowsPerPage={rowsPerPage}
            page={page}
            onPageChange={handleChangePage}
            onRowsPerPageChange={handleChangeRowsPerPage}
          />
        </Paper>
        <TaskModal
          task={recievedTasks.find((task) => task.id === modal.id)}
          open={modal.open}
          handleClose={handleClose}
          onChange={onChange}
        />
      </Box>
    );
  }
}


function descendingComparator(a, b, orderBy) {
  if (b[orderBy] < a[orderBy]) {
    return -1;
  }
  if (b[orderBy] > a[orderBy]) {
    return 1;
  }
  return 0;
}

function getComparator(order, orderBy) {
  return order === "desc"
    ? (a, b) => descendingComparator(a, b, orderBy)
    : (a, b) => -descendingComparator(a, b, orderBy);
}

function stableSort(array, comparator) {
  const stabilizedThis = array?.map((el, index) => [el, index]);
  stabilizedThis.sort((a, b) => {
    const order = comparator(a[0], b[0]);
    if (order !== 0) {
      return order;
    }
    return a[1] - b[1];
  });
  return stabilizedThis.map((el) => el[0]);
}
