import { Grid} from "@mui/material";
import { memo, useEffect, useState } from "react";

const CalendarStandartCell = ({children, xs, hours, dayNumber,  createTaskInCellHandler, handleOpen, modal, divRef, dragTaskHandler, linesInDay}) => {
    const [isThisCell, setIsThisCell] = useState(false)
    useEffect(()=>{
        if(!modal) {
            setIsThisCell(false);
        }
    }, [modal])

    const dragOverHandler = (e) => {
        e.preventDefault();
      }
    
    const dropHandler = (e) => {
        e.stopPropagation()
        e.preventDefault();
        dragTaskHandler(dayNumber, parseInt(hours.split(':')[0]))
    }

    return <>
        <Grid  
            item xs={xs} 
            sx={{position: 'relative', height:  linesInDay?.length ? `${35*linesInDay}px` : '35px'}} 
            onClick={(e)=>{createTaskInCellHandler(dayNumber, hours); setIsThisCell(true); handleOpen(e)}}
            onDragOver={(e)=>{dragOverHandler(e)}}
            onDrop={(e)=>{dropHandler(e)}}
        >
            {children}
        {isThisCell ?  
        <Grid  
            sx={{ position: 'relative', height: '29px', backgroundColor: 'lightgreen', whiteSpace: 'nowrap', overflow: 'hidden', textOverflow: 'ellipsis', borderRadius: '10px', margin: '3px 10px', display: 'flex', justifyContent: 'flex-start', alignItems: 'center', paddingLeft: '5px', zIndex: '5'}}  
            >
            <span>
                Задача
            </span>
        </Grid> : null}
        <div style={{position: 'absolute', height: children ? divRef : 0, width: '1px', backgroundColor: 'black', right: '0', top: '0', zIndex: '3'}}>

        </div>
        </Grid>
    </>
};

export default memo(CalendarStandartCell,  (prevProps, nextProps)=>{
    if(!prevProps.modal) return false
    if(nextProps.modal) return true
  });