import { Grid } from "@mui/material";
import { memo, useEffect, useMemo, useState } from "react";
import CalendarStandartCell from "../CalendarStandartCell.js/CalendarStandartCell";
import CalendarTask from "../CalendarTask/CalendarTask";
import EmptyBox from "./EmptyBox/EmptyBox";

const CalendarRowDay = ({xs, hoursInDay, createTaskInCellHandler, currentTask, handleOpen, modal, setCurrentTask, year, month, tasks, day, hourFormat, setCurrentLine, currentLine, dragTaskHandler, increaseTaskHandler, reduceTaskHandler}) => {

  const hours = useMemo(()=>{ 
    return hoursInDay.map((hour)=>parseInt(hour.split(':')[0]))},
  [hoursInDay])

  const availableTasks = useMemo(() => {
    const tasksInDay = tasks.filter((task)=> {
    if (year === task.infoForCell.startYear) {
      if (month + 1 === task.infoForCell.startMonth) {
        if (day.dayNumber === task.infoForCell.startDay) {
              return task
          } else {return false}   
        } else {return false}   
      } else {return false}      
    })
    return tasksInDay
  }, [tasks, month, year, day.dayNumber])

  const sortedTasks = useMemo(() => {
    if (availableTasks.length) {
      const newSortedArr = [...availableTasks].sort(function(a,b){
        const durattionFirstDate = a.infoForCell.endHour - a.infoForCell.startHour
        const durattionSecondDate = b.infoForCell.endHour - b.infoForCell.startHour
        return durattionSecondDate - durattionFirstDate;
      })
      return newSortedArr
    }
  }, [availableTasks])

  const linesInDay = useMemo(() => {
    let hourDiff
    let hourDiffEnd
    const lines = []
    if (hourFormat) {
      hourDiff = 1
      hourDiffEnd = 0
    } else {
      hourDiff = 2
      hourDiffEnd = 1
    }
    
    if (availableTasks.length) {
      lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
      for (let k = 0; k < sortedTasks.length; k++) {
        let skipLine = false
          for (let j = 0; j < lines.length; j++) {
            const line = lines[j]
            const task = sortedTasks[k]
            if (skipLine) {
              skipLine = false
              break;
            }
            for (let i = 0; i < line.length; i++) {
              const hour = hours[i]
              let havePlace = true
              if (((task.infoForCell.endHour <= hour || task.infoForCell.startHour  <= hour) && (task.infoForCell.endHour > hour))  
              || (!hourFormat && task.infoForCell.startHour >= hour  && task.infoForCell.endHour < hour + hourDiff)
              || (!hourFormat && task.infoForCell.startHour === hour + hourDiffEnd && task.infoForCell.endHour > hour)
              || (task.infoForCell.endMinute <= 59 && task.infoForCell.endHour === hour)) {
                if (!isNaN(line[i])) {
                  for (let a = 0; a < hours.length; a++) {
                    const hour = hours[a]
                    if ((task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour + hourDiffEnd) || (!hourFormat && task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour)) {
                      if (isNaN(line[a])) {
                        havePlace = false
                        break;
                      }
                    }
                  }
                  if (!havePlace) {
                    if (j + 1 === lines.length) {
                      lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
                    }
                    havePlace = true  
                    break;
                  }
                  line[i] += `-${k}`
                  if ((task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour + hourDiffEnd) 
                  || (!hourFormat && task.infoForCell.endMinute === 59 && task.infoForCell.endHour === hour)) {
                    skipLine = true
                    break;
                  }
                } else {
                    if (j + 1 === lines.length) {
                      lines.push(hoursInDay.map((hour)=>parseInt(hour.split(':')[0])))
                    }
                    break;
                }
              } 
            }
          }
      }
    }
    return lines
  }, [availableTasks.length, hourFormat, hours, hoursInDay, sortedTasks])

  const getBoxesInLine = (line) => {
    if (line) {
      let xs = 12/hoursInDay.length
      const boxes = []
      for (let i = 0; i < line.length; i++) {
        if (!isNaN(line[i])) {
          // if (boxes[boxes.length -1]?.task === null) {
          //   boxes[boxes.length -1].xs += xs
          // } else {
          boxes.push({xs: xs, task: null, hour: line[i]})
          //  }
        } else {
          const task = sortedTasks[line[i].split('-')[1]]
          const taskIsThere = boxes.find((taskFind)=>{
            if (taskFind?.task?.id === task.id) return taskFind
          })
          if (taskIsThere) {
            taskIsThere.xs +=xs
          } else {
            boxes.push({
              xs: xs, 
              task: sortedTasks[line[i].split('-')[1]]})
          }
        }
      }
      return boxes
    }
  }

  return <>
      <Grid 
        container
        item
        xs={10.8}
        align='center'
        >
          
          {hoursInDay.map((hour, i)=>{
            return (
              <CalendarStandartCell
                  linesInDay={linesInDay}
                  key={i} 
                  item xs={xs}
                  createTaskInCellHandler={createTaskInCellHandler}
                  hours={hour}
                  dragTaskHandler={dragTaskHandler}
                  dayNumber={day.dayNumber}
                  currentTask={currentTask}
                  handleOpen={handleOpen}
                  modal={modal}
                >
              </CalendarStandartCell>
              ) 
            })}

            {linesInDay?.map((line, i)=>{
              const boxes = getBoxesInLine(line)
              return(
              <Grid key={i} container sx={{height: '35px', backgroundColor: 'rgb(0,0,0,0)', marginBottom: '5px'}}>
                {boxes.map((box, index)=>{
                  if (box.task) {
                    return (<Grid 
                        item xs={box.xs} 
                        sx={{height: '35px', marginBottom: '5px'}}
                        >
                      <CalendarTask
                       dragTaskHandler={dragTaskHandler}
                       setCurrentLine={()=>{setCurrentLine(day.dayNumber)}} 
                       currentTask={currentTask}
                       currentLine={currentLine}
                       hour={parseInt(hours[index])}
                       line={day.dayNumber}
                       task={box.task}
                       hourFormat={hourFormat}
                       setCurrentTask={setCurrentTask} 
                       handleOpen={handleOpen}
                       increaseTaskHandler={increaseTaskHandler} 
                       reduceTaskHandler={reduceTaskHandler}
                       />
                    </Grid>)
                  } else {
                    return (<EmptyBox 
                      modal={modal}
                      dayNumber={day.dayNumber}
                      hourNumber={box.hour}
                      handleOpen={handleOpen}
                      dragTaskHandler={dragTaskHandler}
                      createTaskInCellHandler={createTaskInCellHandler}
                      xs={box.xs}
                      >
                      </EmptyBox>)
                  }
                })}
              </Grid>)
            })}

            <Grid container sx={{height: '35px', backgroundColor: 'rgb(0,0,0,0)', marginBottom: '5px'}}>
              {hoursInDay.map((hour, i)=>{
                const hourNumber = parseInt(hour)
                return(<EmptyBox 
                  key={i}
                  modal={modal}
                  dayNumber={day.dayNumber}
                  hourNumber={hourNumber}
                  handleOpen={handleOpen}
                  dragTaskHandler={dragTaskHandler}
                  createTaskInCellHandler={createTaskInCellHandler}
                  xs={xs}
                  >
                  </EmptyBox>)
              })}
            </Grid>
        </Grid>
    </>
};

export default memo(CalendarRowDay);

