import {
    Column,
    Entity,
    PrimaryGeneratedColumn,
    CreateDateColumn,
    BaseEntity,
    ManyToOne,
    ManyToMany,
    OneToMany,
    JoinTable
  } from 'typeorm';
  // import {User} from './User';
  import {Task} from './Task';
  import {Member} from './Member';



  interface IProject{
    id: string;
    title: string;
    color: string;
    // admin:User;
    // workers:User[];
    tasks:Task[]|null;
    createdAt: Date;
    active:boolean;
    // dateDue: Date| null;
    // department:boolean;
    members: Member[];
  }

  @Entity({ name: 'Project' })
  export class Project extends BaseEntity implements IProject{

    @PrimaryGeneratedColumn('uuid')
    id!: string

    @Column({ name: 'title', type: 'varchar', length:100,nullable: false})
    title!: string

    @CreateDateColumn({ name: 'createdAt', type: Date, default: new Date() })
    createdAt!: Date;

    @Column({ name: 'color', type: 'varchar', length:100,nullable: true })
    color!: string;

    @Column({ name: 'active',type: 'boolean', default: true })
    active!: boolean;

    // @Column({ name: 'dateDue', type: Date, default: null })
    // dateDue!: Date| null;

    // @Column({ name: 'department', type: Boolean,nullable:true ,default: false})
    // department!: boolean;

    // @ManyToOne(() => User, (user: { projects: Project[]; }) => user.projects,{eager : true})
    // admin!: User;
    
    @OneToMany(() => Task, (task: { project: Project; })=>task.project)
    tasks!:Task[]|null;

    @OneToMany(() => Member, (member: { project: Project; })=>member.project)
    members!:Member[];
        
    // @ManyToMany(() => User, (user: { projects: Project[]; }) => user.projects,{eager : true,cascade: true,  onUpdate:'CASCADE',onDelete: 'CASCADE'})
    // @JoinTable()
    // workers!: User[];
 }