import axios from "../../axiosPlanner";

import { CREATE_MEMBER_SUCCESS, CREATE_PROJECT_SUCCESS, DELETE_MEMBER_FAILURE, DELETE_MEMBER_REQUEST, DELETE_MEMBER_SUCCESS, FETCH_ALL_USER_PROJECTS_SUCCESS, FETCH_MEMBERS_ERROR, FETCH_MEMBERS_REQUEST, FETCH_MEMBERS_SUCCESS, FETCH_PROJECTS_ERROR, FETCH_PROJECTS_REQUEST, FETCH_PROJECTS_SUCCESS, FETCH_PROJECT_SUCCESS } from "../actionTypes/projectsActionTypes";
import { showNotification } from "./commonActions";

const fetchProjectsRequest = () => {
    return {type: FETCH_PROJECTS_REQUEST}
};
const fetchProjectsSuccess = (projects) => {
    return {type: FETCH_PROJECTS_SUCCESS, projects};
};
const fetchProjectsError = (error) => {
    return {type: FETCH_PROJECTS_ERROR, error};
}
const fetchProjectSuccess = (project) => {
    return {type: FETCH_PROJECT_SUCCESS, project};
};

const createProjectSuccess = () => {
    return {type: CREATE_PROJECT_SUCCESS};
};

const createMemberSuccess = (member) => {
    return {type: CREATE_MEMBER_SUCCESS, member};
};

const deleteMemberRequest = () => {
    return {type: DELETE_MEMBER_REQUEST}
  };
   
  const deleteMemberSuccess = () => {
    return {type: DELETE_MEMBER_SUCCESS}
  };
  
  const deleteMemberFailure = (error) => {
    return {type: DELETE_MEMBER_FAILURE, error}
  };
  
  export const deleteMember = (memberId, projectId) => {
    return async (dispatch) => {
        dispatch(deleteMemberRequest());
        try {
          const response = await axios.delete(`/projects/remove-user/${memberId}`, { data: { projectId: projectId}});
          console.log("deleteMember ", response.data)
          dispatch(deleteMemberSuccess())
          dispatch(fetchProject(projectId))
        } catch (error) {
          dispatch(deleteMemberFailure(error.response.data));
        }
    }
  }

export const fetchProjects = () => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/my");
            dispatch(fetchProjectsSuccess(response.data));
        } catch(e) {
            dispatch(fetchProjectsError(e));
        }
    };
};

export const fetchProject = (id) => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/" + id);
            dispatch(fetchProjectSuccess(response.data));
            console.log("fetch project ", response.data)
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    }
};

export const createProject = (projectData, navigate) => {
    return async (dispatch) => {
        try {
           const response = await axios.post("/projects", projectData);
            dispatch(createProjectSuccess());
            console.log(response.data)
           navigate("/projects/" + response.data.project.id)
            dispatch(showNotification("Проект успешно создан"))
        } catch (e) {
            console.log(e);
            dispatch(showNotification("Не удалось создать проект", "error"))
        }
    };
}

export const createMember = (memberData, navigate) => {
    return async (dispatch) => {
        try {
            console.log(memberData)
           const response = await axios.post("/projects/add-user", memberData);
            dispatch(createMemberSuccess());
            console.log(memberData)
           navigate("/projects/")
            dispatch(showNotification("Участник успешно добавлен"))
        } catch (e) {
            console.log(e);
            dispatch(showNotification("Не удалось добавить участника", "error"))
        }
    };
}

const fetchAllUserProjectsSuccess = (projects) => {
    return {type: FETCH_ALL_USER_PROJECTS_SUCCESS, projects};
};

export const fetchAllUserProjects = () => {
    return async dispatch => {
        dispatch(fetchProjectsRequest());
        try {
            const response = await axios.get("/projects/my");
            dispatch(fetchAllUserProjectsSuccess(response.data.projects));
        } catch (e) {
            dispatch(fetchProjectsError(e));
        }
    }
}

