import * as React from "react";
import TableCell from "@mui/material/TableCell";
import Input from "@mui/material/Input";
import moment from "moment";

const CustomTableCell = ({
  task,
  name,
  value,
  value2,
  onChange,
  onModalOpen,
  placeholder,
  user,
}) => {
  const styles =  placeholder ?  { width: "100%" } : { width: "auto" };
  const divStyle = {
    display: "flex",
    justifyContent: "space-between",
    flexDirection: "column",
    fontSize: "12px", 
  };

  const duration = moment.duration(
    moment(task?.dateTimeTasks[0]?.dateTimeDue).diff(
      moment(task?.dateTimeTasks[0]?.dateTimeStart)
    )
  );
  const hours = Math.round(duration.asHours());

  if (task) {
    return (
      <>
        <TableCell
          onClick={(e) => (onModalOpen ? onModalOpen(e, task) : null)}
          align="left"
          // style={styles}
        >
          {(task.isEditMode &&
            onChange &&
            name !== "author" &&
            task.author?.id === user?.id) ||
          placeholder ? (
            <Input
              placeholder={placeholder}
              value={value}
              name={name}
              onChange={(e) => onChange(e, task)}
              style={styles}
            />
          ) : name !== "dateTimeStart" ? (
            <span>{value}</span>
          ) : (
            <div style={divStyle}>
              <span>{value}</span>
              <span>{value2}</span>
              <span>часы:{hours}</span>
            </div>
          )}
        </TableCell>
      </>
    );
  }
};

export default CustomTableCell;
