import Box from '@mui/material/Box';
import Modal from '@mui/material/Modal';
import { useEffect, useRef, useState } from 'react';


export default function ModalTask({modal, handleClose, children}) {

  const [windowDimenion, detectHW] = useState({
    winWidth: window.innerWidth,
    winHeight: window.innerHeight,
  })

  const detectSize = () => {
    detectHW({
      winWidth: window.innerWidth,
      winHeight: window.innerHeight,
    })
  }

  useEffect(() => {
    window.addEventListener('resize', detectSize)
    return () => {
      window.removeEventListener('resize', detectSize)
    }
  }, [windowDimenion])


  const getYCordinatesToModal = () => {
    if (windowDimenion.winHeight > modal.yClickСordinates + 450) {
      return modal.yClickСordinates - modal.yDiv - modal.yDivClick
    } else {
      return modal.yClickСordinates - modal.yDiv - modal.yDivClick - ((modal.yClickСordinates + 450) - windowDimenion.winHeight) - 30
    }
  }
  const getXCordinatesToModal = () => {
    if (windowDimenion.winWidth > modal.xClickСordinates + 270 + modal.xDiv) {
      return modal.xClickСordinates + modal.xDiv - modal.xDivClick + 10
    } else {
      return windowDimenion.winWidth - (windowDimenion.winWidth - modal.xClickСordinates) - modal.xDivClick - 270 - 80
    }
  }
  const style = {
    display: 'flex',
    flexDirection: 'column',
    position: 'absolute',
    top: getYCordinatesToModal(),
    left: getXCordinatesToModal(),
    width: 270,
    height: 450,
    bgcolor: 'background.paper',
    border: '2px solid #000',
    boxShadow: 24,
    p: 4,
  };
  return (
    <>
      <Modal
        id='test_modal_task'
        open={modal.open}
        onClose={handleClose}
        aria-labelledby="modal-modal-title"
        aria-describedby="modal-modal-description"
        BackdropProps={{ style: { backgroundColor: 'rgba(255,255,255, 0)' } }}
      >
        <Box sx={style}>
          {children}
        </Box>
      </Modal>
    </>
  );
}