import {Grid} from "@mui/material";
import ProjectItem from "../ProjectItem/ProjectItem";

const ProjectsList = ({projects}) => {
    console.log(projects)
    return (
        <Grid item container direction="column" spacing={1}>
            {projects?.map(project => {
                return <ProjectItem
                    tasks={project.tasks}
                    workers={project.workers}
                    title={project.title}
                    createdAt={project.createdAt}
                    dateDue={project.dateDue}
                    admin={project.admin}
                    id={project.id}
                    key={project.id}
                />
            })}
        </Grid>
    );
};

export default ProjectsList;