import * as React from "react";
import TableCell from "@mui/material/TableCell";
import Input from "@mui/material/Input";
import moment from "moment";

const CustomTableCell = ({
  task,
  name,
  value,
  value2,
  onChange,
  onModalOpen,
  placeholder,
  user,
  width,
}) => {
  const styles = { width: width, padding: "1px 16px 1px 1px" };
  const inputStyles = placeholder
    ? { width: "100%", padding: "1px" }
    : { padding: "1px" };

  const divStyle = {
    display: "flex",
    justifyContent: "space-between",
    flexDirection: "column",
    fontSize: "12px",
  };

  const duration = moment.duration(
    moment(task?.dateTimeTasks[0]?.dateTimeDue).diff(
      moment(task?.dateTimeTasks[0]?.dateTimeStart)
    )
  );
  const hours = Math.round(duration.asHours());

  if (task) {
    return (
      <>
        <TableCell
          onClick={(e) => (onModalOpen ? onModalOpen(e, task) : null)}
          align="left"
          style={styles}
        >
          {(task.isEditMode &&
            onChange &&
            name !== "author" &&
            task.author?.id === user?.id) ||
          placeholder ? (
            <Input
              placeholder={placeholder}
              value={value}
              name={name}
              onChange={(e) => onChange(e, task)}
              style={inputStyles}
            />
          ) : name !== "dateTimeStart" ? (
            <span>{value}</span>
          ) : (
            <div style={divStyle}>
              <span>{value}</span>
              <span>{value2}</span>
              <span>часы:{hours}</span>
            </div>
          )}
        </TableCell>
      </>
    );
  }
};

export default CustomTableCell;
