import { FormControlLabel, Grid, Switch } from "@mui/material";
import { Box } from "@mui/system";
import CalendarRow from "../../CalendarRow/CalendarRow";
import CalendarSmallCell from "../../CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "../../CalendarStandartCell/CalendarStandartCell";
import CalendarColumnDayWeek from "./CalendarColumnDayWeek/CalendarColumnDayWeek";
import { getCurrentWeekDayString } from "./Helpers";

function WeekCalendarBody({ week, hoursInDay, hourFormat, setHourFormat, date, tasks }) {


  return (
    <>
      <Box style={{ marginBottom: '30px' }}>
        <Box style={{ position: 'sticky', top: '0px', zIndex: '10', backgroundColor: 'lightgrey' }}>
          <CalendarRow
          >
            <CalendarSmallCell xs={1}>
              <FormControlLabel
                control={<Switch color="primary" checked={hourFormat} onChange={() => { setHourFormat(() => !hourFormat) }} />}
                label="1 час"
                labelPlacement="end"
              />
            </CalendarSmallCell>
            {week?.map((weekDay, i) => {
              return (
                <CalendarStandartCell key={i} xs={11 / week.length}>
                  <span style={{ display: 'block', fontWeight: "600" }}>{weekDay}</span>
                  <span style={{ marginBottom: '10px' }}>{getCurrentWeekDayString(i)}</span>
                </CalendarStandartCell>
              )
            })}
          </CalendarRow>
        </Box>

        <Grid container>
          <CalendarRow week={true}>
            <Grid item xs={0.995} flexDirection='column'>
              {hoursInDay?.map((hour, i) => {
                return (
                  <CalendarSmallCell key={i} week={true}>
                    {hour}
                  </CalendarSmallCell>)
              })}
            </Grid>

            <Grid item xs={11.005}>
              <CalendarRow week={true}>
                {week?.map((weekDay, i) => {
                  return (
                      <CalendarColumnDayWeek
                        key={i}
                        hoursInDay={hoursInDay}
                        tasks={tasks}
                        month={date.month}
                        year={date.year}
                        day={weekDay}
                        hourFormat={hourFormat}
                      />
                  )
                })}
              </CalendarRow>
            </Grid>

          </CalendarRow>
        </Grid>
      </Box>
    </>
  );
}

export default WeekCalendarBody;