import { Box } from "@mui/material"
import { useEffect, useState } from "react"


function CalendarWeekTask({ height, width, left, top, task, zIndex }) {

  const [color, setColor] = useState('')
  useEffect(() => {
    if (task.priority) {
      if (task.priority === 'A') setColor('rgb(32, 138, 250)')
      if (task.priority === 'B') setColor('lightgreen')
      if (task.priority === 'C') setColor('yellow')
    } else {
      setColor('rgb(171, 157, 157);')
    }
  }, [task])

  const styles = {
    borderRadius: '5px',
    border: '1px solid white',
    backgroundColor: color,
    height: `${height}px`,
    width: `${width}px`,
    position: 'absolute',
    left: `${left}px`,
    top: top,
    zIndex: zIndex,
    textAlign: 'left',
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    '&:hover': {
      cursor: 'pointer',
      boxShadow: 'inset 0 0 100px 100px rgba(255, 255, 255, 0.3)'
    },
    "&:active": {
      zIndex: 100
    }
  }

  return (
    <Box
      sx={styles}>
        <span style={{textOverflow: 'ellipsis', padding: '5px 0 0 5px'}}>
          {task.title} 
        </span>
    </Box>);
}

export default CalendarWeekTask;