import { useMemo } from "react";
import { getHoursInDayNumbers, getAvailableTasks, getLinesInDay, getSortedTasks } from "../../../../../helpers/CalendarHelpers";
import CalendarStandartCell from "../../../CalendarStandartCell/CalendarStandartCell";
import { useEffect, useRef, useState } from "react";
import { Grid } from "@mui/material";
import CalendarWeekTask from "./CalendarWeekTask/CalendarWeekTask";



function CalendarColumnDayWeek({ hoursInDay, tasks, month, year, day, hourFormat }) {
  const [columnDayHeight, setColumnDayHeight] = useState(0)

  const dayColumnRef = useRef('')
  useEffect(() => {
    setColumnDayHeight(prev => dayColumnRef.current.offsetHeight)
  }, [hourFormat])

  const hours = useMemo(() => {
    return getHoursInDayNumbers(hoursInDay)
  }, [hoursInDay])

  const taskStyle = {
    backgroundColor: 'red',
    height: `${columnDayHeight / hours.length}px`,
    width: '96%',
    margin: '0 auto',
    position: 'absolute',
    bottom: 0,
    marginLeft: 'auto',
    marginRight: 'auto',
    left: '0',
    right: '0',
  }

  const availableTasks = useMemo(() => {
    return getAvailableTasks(tasks, year, month, day)
  }, [tasks, month, year, day])

  const sortedTasks = useMemo(() => {
    return getSortedTasks(availableTasks)
  }, [availableTasks])


  const linesInDay = useMemo(() => {
    return getLinesInDay(availableTasks, sortedTasks, hoursInDay, hours, hourFormat)
  }, [availableTasks, hourFormat, hours, hoursInDay, sortedTasks])

  const getBoxesInLine = (line, hoursInDay, sortedTasks, linesInDay) => {
    if (line) {
      let xs = 12 / hoursInDay.length
      const boxes = []
      for (let i = 0; i < line.length; i++) {
        if (!isNaN(line[i])) {
        } else {
          const task = sortedTasks[line[i].split('-')[1]]
          const taskIsThere = boxes.find((taskFind) => {
            if (taskFind?.task?.id === task.id) return taskFind
            return false
          })
          const step = columnDayHeight / hours.length
          if (taskIsThere) {
            taskIsThere.lastHour = i
            taskIsThere.height += step
          } else {
            let tasksInHour = 0
            for (let line of linesInDay) {
                if (isNaN(line[i])) {
                  tasksInHour++
                }
            } 
            boxes.push({
              tasksInHour: tasksInHour,
              top: step * i,
              height: step,
              firstHour: i,
              lastHour: i,
              task: sortedTasks[line[i].split('-')[1]]
            })
          }
        }
      }
      return boxes
    }
  }
  const arr = ['red', 'blue', 'yellow', 'purple', 'green']
  
  return (<>
    <Grid item xs={12 / 7} ref={dayColumnRef} sx={{ position: 'relative'}}>
      {linesInDay?.map((line, i) => {
        const boxes = getBoxesInLine(line, hoursInDay, sortedTasks, linesInDay)
        return (<>
          {boxes.map((task, index) => {
            const amount = task.tasksInHour
            const oneTaskPrecentWidth = 100 / amount
            const left = oneTaskPrecentWidth * dayColumnRef.current.offsetWidth / 100 * i
            const oneTaskWidth = dayColumnRef.current.offsetWidth - (oneTaskPrecentWidth * dayColumnRef.current.offsetWidth / 100) * i
            const zIndex = 10 + i
            return (
              <CalendarWeekTask
                key={index}
                width={oneTaskWidth}
                height={task.height}
                left={left}
                task={task.task}
                top={task.top}
                zIndex={zIndex}
              >

              </CalendarWeekTask>
              

              )
          })}
        </>)

      })}
      {hoursInDay?.map((hour, i) => {
        return (
          <CalendarStandartCell key={i} week={true}>
          </CalendarStandartCell>
        )
      })}
    </Grid>

  </>);
}

export default CalendarColumnDayWeek;