import { Box, FormControlLabel, Switch } from "@mui/material";
import { useState } from "react";
import CalendarRow from "../../CalendarRow/CalendarRow";
import CalendarSmallCell from "../../CalendarSmallCell/CalendarSmallCell";
import CalendarStandartCell from "../../CalendarStandartCell/CalendarStandartCell";
import ModalTask from "../../../UI/ModalTask/ModalTask"
import MonthCalendarModalContent from "../../CalendarModalTaskContent/CalendarModalTaskContent";
import CalendarRowDay from "./CalendarRowDay/CalendarRowDay";


function MonthCalendarBody({ month, year, tasks, createTaskInCellHandler, currentTask, setCurrentTask, hourFormat, setHourFormat, onChangeCurrentTaskHandler, sendNewTaskHandler, deleteTaskHandler, cellSizes, hoursInDay, daysInMonth, dragTaskHandler, createCopyTask, setCopyTask, copyTask }) {

  const [currentLine, setCurrentLine] = useState('')
  const [modal, setModal] = useState({ open: false, y: 0, x: 0, });
  const handleOpen = (e) => {
    setModal({
      open: true,
      yClickСordinates: e.clientY,
      xClickСordinates: e.clientX,
      yDivClick: e.nativeEvent.offsetY,
      xDivClick: e.nativeEvent.offsetX,
      yDiv: e.target.offsetHeight,
      xDiv: e.target.offsetWidth,
    })
  };

  const handleClose = () => {
    setModal({ ...modal, open: false })
    setCurrentTask({})
  };

  return (
    <Box style={{ marginBottom: '30px' }}>
      <div style={{ position: 'sticky', top: '0px', zIndex: '10', backgroundColor: 'lightgrey' }}>
        <CalendarRow
        >
          <CalendarSmallCell xs={1.2}>
            <FormControlLabel
              control={<Switch color="primary" checked={hourFormat} onChange={() => { setHourFormat(() => !hourFormat) }} />}
              label="1 час"
              labelPlacement="end"
            />
          </CalendarSmallCell>
          {hoursInDay?.map((hours, i) => {
            return (
              <CalendarStandartCell key={i} xs={cellSizes.standarCell}>
                {hours}
              </CalendarStandartCell>
            )
          })}
        </CalendarRow>
      </div>
      {daysInMonth?.map((day, i) => {
        return (
          <CalendarRow
            key={i}
          >
            <CalendarSmallCell xs={cellSizes.smallCell}>{day.dayNumber}</CalendarSmallCell>
            <CalendarSmallCell xs={cellSizes.smallCell}>{day.dayOfWeek}</CalendarSmallCell>
            <CalendarRowDay
              dragTaskHandler={dragTaskHandler}
              xs={cellSizes.dayCell}
              createTaskInCellHandler={createTaskInCellHandler}
              hoursInDay={hoursInDay}
              currentTask={currentTask}
              handleOpen={handleOpen}
              currentLine={currentLine}
              setCurrentLine={setCurrentLine}
              modal={modal.open}
              setCurrentTask={setCurrentTask}
              year={year}
              month={month}
              tasks={tasks}
              day={day}
              hourFormat={hourFormat}
              createCopyTask={createCopyTask}
              copyTask={copyTask}
              setCopyTask={setCopyTask}
            >
            </CalendarRowDay>
          </CalendarRow>
        )
      })}
      <ModalTask
        modal={modal}
        handleClose={() => { handleClose() }}
      >
        <MonthCalendarModalContent
          title={currentTask.title}
          description={currentTask.description}
          priority={currentTask.priority}
          id={currentTask.id}
          startHour={currentTask.infoForCell?.startHour}
          endHour={currentTask.infoForCell?.endHour}
          onChangeCurrentTaskHandler={(e) => { onChangeCurrentTaskHandler(e) }}
          sendNewTaskHandler={() => { sendNewTaskHandler(); handleClose() }}
          deleteTaskHandler={() => { deleteTaskHandler(currentTask.id); handleClose() }}
        />
      </ModalTask>
    </Box>
  );
}

export default MonthCalendarBody;