import { AppBar, Box, FormControlLabel, Switch, Typography } from "@mui/material";
import { memo, useMemo } from "react";
import MultipleSelect from "../../UI/MultipleSelect/MultipleSelect";
import CreateTaskFromButton from "./CreateTaskFromButton/CreateTaskFromButton";


function MyTasksTableToolbar({ addFormStatus, createTaskFromButtonHandler, projects, onCloseFilterByProjects, projectIdListForTaskSelect, setProjectIdListForTaskSelect, activeTasksStatus, setActiveTasksStatus }) {

  const projectsFilter = useMemo(() => {
    if (Array.isArray(projects)) {
      return <MultipleSelect
        projects={projects}
        onCloseFilterByProjects={onCloseFilterByProjects}
        projectIdListForTaskSelect={projectIdListForTaskSelect}
        setProjectIdListForTaskSelect={setProjectIdListForTaskSelect}
      />
    } else {
      return null
    }
  }, [projects, onCloseFilterByProjects, projectIdListForTaskSelect, setProjectIdListForTaskSelect])

  return (
    <AppBar position="static" sx={{ padding: 3 }}>
      <Box sx={{ display: 'flex', alignItems: 'center' }}>
        <Typography
          sx={{ flex: '1 1 100%' }}
          variant="h6"
          id="tableTitle"
          component="div"
        >
          Мои задачи
        </Typography>
        <FormControlLabel
          control={<Switch color='error' checked={activeTasksStatus} onChange={() => { setActiveTasksStatus(prevState=>!prevState) }} />}
          label="Активные задачи"
          labelPlacement="end"
        />
        {projectsFilter}
        <CreateTaskFromButton
          addFormStatus={addFormStatus}
          onClick={() => { createTaskFromButtonHandler() }}
        />
      </Box>
    </AppBar>
  );
}

export default memo(MyTasksTableToolbar)